<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Entity\Wsse;

/**
 * RequestSecurityTokenResponse Entity nach BiPRO Norm (utf-8)
 * Wertet die RequestSecurtiyToken Response eines BiPRO Security Token Webservices aus
 *
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity
 * @since 2016-10-20
 * @version
 */
class RequestSecurityTokenResponseType 
{  
    /**
     * Liefert den SecurityContextToken Knoten als SoapVar für die weitere Verwendung
     * @return \SoapVar
     */
    public function getSecurityContextToken() : \SoapVar
    {
        $oIdentifier = new \SoapVar(
            $this->any['RequestedSecurityToken']->any,
            XSD_STRING,
            '',
            '',
            'Identifier',
            'http://schemas.xmlsoap.org/ws/2005/02/sc'
        );
        
        return (new SecurityContextToken())
            ->setIdentifier($oIdentifier)
            ->encode();
    }
    
    /**
     * Liefert den BiPRO Security Token Identifier
     * @return string
     */
    public function getIdentifier() {
        return $this->any['RequestedSecurityToken']->any;
    }
    
    /**
     * Liefert den Token Type
     * @return string
     */
    public function getTokenType() {
        return $this->any['TokenType'];
    }
    
    /**
     * Liefert das Lifetime Objekt als anonyme Klasse, da das Lifetime Entity die Eigenschaften als SoapVar Instanzen erwartet
     * @todo Lifetime SoapVar Eigenschaften überdenken
     * @return anonymous class instance
     */
    public function getLifetime() 
    {
        return new class ($this->any['Lifetime']->Created->_, $this->any['Lifetime']->Expires->_) {
            protected $Created;
            protected $Expires;
            
            public function __construct($Created, $Expires) {
                $this->Created = $Created;
                $this->Expires = $Expires;
            }
            
            public function getCreated() {
                return $this->Created;
            }
            
            public function getExpires() {
                return $this->Expires;
            }
        };
    }
}