<?php
namespace MMNewmedia\BiPRO\Norm410;

use MMNewmedia\BiPRO\Norm410\Soap\WsseHeader;
use MMNewmedia\BiPRO\Entity\Wsse\RequestSecurityToken;
use MMNewmedia\BiPRO\Entity\Wsse\RequestSecurityTokenResponseType;
use MMNewmedia\BiPRO\Loader\StandardAutoloader;

// Autoloader initialisieren
require_once('../lib/loader/StandardAutoloader.php');
$aClassMap = require_once('../autoload_classmap.php');

$oAutoloader = new StandardAutoloader();
$oAutoloader->addClassMap($aClassMap);
$oAutoloader->register();

try {
	// URL definieren
	$sUrl = $url = "http" . (($_SERVER['SERVER_PORT'] == 443) ? "s://" : "://") . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
	$sUrl = str_replace(basename(__FILE__), '' , $sUrl);
	
	// Soap Client
	$sWsdl = $sUrl . 'view/assets/wsdl/SecurityTokenService_2.1.0.1.0.wsdl';
	$oClient = new \SoapClient(
		$sWsdl,
		[
			'trace' 		=> true,
			'exception' 	=> true,
			'cache_wsdl' 	=> WSDL_CACHE_NONE,
			'compression' 	=> SOAP_COMPRESSION_ACCEPT | SOAP_COMPRESSION_GZIP,
			'soap_version' 	=> SOAP_1_2,
			'classmap'		=> [
			    'RequestSecurityTokenResponseType' => RequestSecurityTokenResponseType::class,
			],
		]
	);
	
	$oHeaders = new WsseHeader('Foo', 'Bar');
	$oClient->__setSoapHeaders($oHeaders);
	
	$oRequestType = new \SoapVar(
		'http://schemas.xmlsoap.org/ws/2005/02/trust/Issue',
		XSD_STRING,
		'',
		'',
		'RequestType',
		'http://schemas.xmlsoap.org/ws/2005/02/trust'
	);
	
	$oTokenType = new \SoapVar(
		'http://schemas.xmlsoap.org/ws/2005/02/sc/sct',
		XSD_STRING,
		'',
		'',
		'TokenType',
		'http://schemas.xmlsoap.org/ws/2005/02/trust'
	);
	
	$oRequestSecurityToken = (new RequestSecurityToken())
	    ->setRequestType($oRequestType)
	    ->setTokenType($oTokenType)
	    ->encode();
	
	$oResult = $oClient->RequestSecurityToken($oRequestSecurityToken);
	
	$sSecurityToken = $oResult->getIdentifier();
	$oLifetime = $oResult->getLifetime();
	
	echo '<h2>Security Token</h2>';
	echo '<p><strong>Bezeichnung:</strong> ' . $sSecurityToken . '<br><strong>Beginn:</strong> ' . $oLifetime->getCreated() . '<br><strong>Ablauf:</strong> ' . $oLifetime->getExpires() . '</p>';
	
	$oDocRequest = new \DomDocument();
	$oDocRequest->formatOutput = true;
	$oDocRequest->loadXML($oClient->__getLastRequest());
	
	echo '<h2>Request</h2>';
	echo '<p><pre>' . htmlentities($oDocRequest->saveXML()) . '</pre></p>';
	
	$oDocResponse = new \DomDocument();
	$oDocResponse->formatOutput = true;
	$oDocResponse->loadXML($oClient->__getLastResponse());
	
	echo '<h2>Response</h2>';
	echo '<p><pre>'. htmlentities($oDocResponse->saveXML()) . '</pre></p>';
	
} catch (\SoapFault $e) {
    
    // Behandlung von Soap Faults
	echo "<h3>Soap Fault</h3><pre>";
	var_dump($e);
	echo "</pre>";
	
	// Wenn der Client initialisiert werden konnte, können auch die letzte Response und das letzte Request dargestellt werden
	if ($oClient) {
	    // Letztes Request
	    $oDoc = new \DoMDocument();
	    $oDoc->formatOutput = true;
	    $oDoc->loadXML($oClient->__getLastRequest());
	    
	    echo "<pre>";
	    var_dump(htmlentities($oDoc->saveXML()));
	    echo "</pre>";
	    
	    // Letzte Response
	    $oDoc = new \DoMDocument();
	    $oDoc->formatOutput = true;
	    $oDoc->loadXML($oClient->__getLastResponse());
	    
	    echo "<pre>";
	    var_dump(htmlentities($oDoc->saveXML()));
	    echo "</pre>";
	}
}