<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Norm410\Entity;

use MMNewmedia\BiPRO\Entity\Wsse\Lifetime;
use MMNewmedia\BiPRO\Entity\Wsse\SecurityContextToken;
use MMNewmedia\BiPRO\Entity\Wsse\RequestedSecurityToken;
use MMNewmedia\BiPRO\Entity\Wsse\RequestSecurityTokenResponse;

/**
 * RequestSecurityToken Model Klasse (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage norm410.model
 * @since 2016-03-03
 * @version
 */
class Response 
{	
	/**
	 * Setzt die Response zusammen
	 * 
	 * @return \SoapVar
	 */
	public function RequestSecurityToken() : \SoapVar
	{
		// TokenType Knoten
		$oTokenType = new \SoapVar(
			'http://schemas.xmlsoap.org/ws/2005/02/sc/sct',
			XSD_STRING,
			'',
			'',
			'TokenType',
			'http://schemas.xmlsoap.org/soap/envelope/'
		);
		
		// Lifetime Knoten
		$oDateTime = new \DateTime();
		$oCreated = new \Soapvar(
			$oDateTime->format('Y-m-d H:i:s'),
			XSD_STRING,
			'',
			'',
			'Created',
			'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd'
		);
		
		$oDateTime->modify('+1 hour');
		$oExpires = new \SoapVar(
			$oDateTime->format('Y-m-d H:i:s'),
			XSD_STRING,
			'',
			'',
			'Expires',
			'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd'
		);
		
		$oLifetime = (new Lifetime())
		    ->setCreated($oCreated)
		    ->setExpires($oExpires)
		    ->encode();
		
		// RequestedSecurityToken Knoten
		$sHash = 'bipro:' . md5(microtime());
		$oIdentifier = new \SoapVar(
			$sHash,
			XSD_STRING,
			'',
			'',
			'Identifier',
			'http://schemas.xmlsoap.org/ws/2005/02/sc'
		);
		
		$oSecurityContextToken = (new SecurityContextToken())
		    ->setIdentifier($oIdentifier)
		    ->encode();
		
		$oRequestedSecurityToken = (new RequestedSecurityToken())
		    ->setSecurityContextToken($oSecurityContextToken)
		    ->encode();
		
		// BiPROVersion Knoten
		$oBiPROVersion = new \SoapVar(
			'2.1.0.1.0',
			XSD_STRING,
			'',
			'',
			'BiPROVersion',
			'http://www.bipro.net/namespace/allgemein'
		);
		
		return (new RequestSecurityTokenResponse())
		    ->setTokenType($oTokenType)
		    ->setLifetime($oLifetime)
		    ->setRequestedSecurityToken($oRequestedSecurityToken)
		    ->setBiPROVersion($oBiPROVersion)
		    ->encode();
	}
}