<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Entity\Nachrichten;

use MMNewmedia\BiPRO\Entity\NullProperties;

/**
 * BiPROException Klasse
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.nachrichten
 * @since 2018-10-07
 * @version 2.6.0
 */
class BiPROException extends ProzessFehler
{
    use NullProperties;
    
    /**
     * Entfernt alle Properties dieses Objekts, die den Wert NULL haben
     */
    public function removeNullProperties() : void
    {
        $properties = get_object_vars($this);
        foreach ($properties as $name => $value) {
            if ($value === null) {
                unset($this->{$name});
            }
        }
    }
    
    /**
     * @see \MMNewmedia\BiPRO\Entity\Nachrichten\ProzessFehler::encode()
     */
    public function encode() : \SoapVar
    {
        // Entfernen von NULL Eigenschaften über das NullProperties Trait
        $this->remove();
        
        $oEncodedObject = new \SoapVar(
            $this,
            SOAP_ENC_OBJECT,
            '',
            '',
            'BiPROException',
            'http://www.bipro.net/namespace/nachrichten'
        );
        
        return $oEncodedObject;
    }
}