<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Norm410;

use MMNewmedia\BiPRO\Loader\StandardAutoloader;
use MMNewmedia\BiPRO\Norm410\Decorator\AuthDecorator;
use MMNewmedia\BiPRO\Norm410\Entity\Response;

// Autoloader initialisieren
require_once('../lib/loader/StandardAutoloader.php');
$aClassMap = require_once('../autoload_classmap.php');

$oAutoloader = new StandardAutoloader();
$oAutoloader->addClassMap($aClassMap);
$oAutoloader->register();

try {
    // URL definieren
    $sUrl = $url = "http" . (($_SERVER['SERVER_PORT'] == 443) ? "s://" : "://") . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    $sUrl = str_replace(basename(__FILE__), '' , $sUrl);
    
    $sWsdl = $sUrl . 'view/assets/wsdl/SecurityTokenService_2.1.0.1.0.wsdl';
	
    // Soap Server initialisieren
	$oServer = new \SoapServer(
		$sWsdl,
		[
			'encoding' => 'UTF-8',
			'send_errors' => true,
			'soap_version' 	=> SOAP_1_2,
		]
	);
	
	$oService = new AuthDecorator();
	$oService->setClassName(Response::class);
	$oServer->setObject($oService);
	$oServer->handle();
	
} catch (\SoapFault $e) {
	echo "<pre>";
	var_dump($e);
	echo "</pre>";
}