<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Entity\Nachrichten;

use MMNewmedia\BiPRO\Entity\Basis\Objekt;
use MMNewmedia\BiPRO\Entity\BiPROEntity;
use MMNewmedia\BiPRO\Entity\NullProperties;

/**
 * Prozess-Objekt. Alle Anfrage-Nachrichten innerhalb der von der BiPRO definierten Prozesse werden von diesem Datentypen abgeleitet (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.nachrichten
 * @since 2018-10-07
 * @version
 */
abstract class ProzessAnfrage extends Objekt implements BiPROEntity
{
    use NullProperties;
    
    /**
     * BiPRO Version
     * @var \SoapVar
     * @internal ST_Version
     */
    protected $BiPROVersion;
    
    /**
     * Eindeutige (providerspezifische) Identifizierung des anfragenden Systems (bzw. des Service Consumers)
     * @var \SoapVar
     * @interal ST_Text050
     */
    protected $ConsumerID;
    
    /**
     * Liefert die BiPROVersion
     * @return \SoapVar|NULL
     */
    public function getBiPROVersion() : ?\SoapVar
    {
        return $this->BiPROVersion;
    }
    
    /**
     * Setzt die BiPRO Version
     * @param \SoapVar $BiPROVersion
     * @return ProzessAnfrage
     */
    public function setBiPROVersion(\SoapVar $BiPROVersion) : ProzessAnfrage
    {
        $this->BiPROVersion = $BiPROVersion;
        return $this;
    }
    
    /**
     * Liefert die eindeutige Identifizierung des anfragenden Systems
     * @return \SoapVar|NULL
     */
    public function getConsumerID() : ?\SoapVar
    {
        return $this->ConsumerID;
    }
    
    /**
     * Setzt die eindeutige Identifizierung des anfragenden Systems
     * @param \SoapVar $oConsumerID
     * @return ProzessAnfrage
     */
    public function setConsumerID(\SoapVar $oConsumerID) : ProzessAnfrage
    {
        $this->ConsumerID = $oConsumerID;
        return $this;
    }
    
    /**
     * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
     */
    public function encode() : \SoapVar
    {
        // Entfernen von NULL Eigenschaften über das NullProperties Trait
        $this->remove();
        
        $oEncodedObject = new \SoapVar(
            $this,
            SOAP_ENC_OBJECT,
            '',
            '',
            'ProzessAnfrage',
            'http://www.bipro.net/namespace/nachrichten'
        );
        
        return $oEncodedObject;
    }
}