<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Entity;

/**
 * Trait zur Handhabung von Eigenschaften eines Objektes, die den Wert NULL haben.
 * Im durch den Soap Client oder Soap Server erstellten XML Strings werden Eigenschaften eines Objektes mit dem Wert NULL
 * als XML Knoten ohne Wert geliefert. Diese nillable Knoten können, sofern sie als nillable beschrieben sind, entfernt werden.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2018 MM Newmedia <https://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity
 * @since 2018-10-07
 * @version 2.6.0
 */
trait NullProperties
{
    /**
     * Entfernt alle Properties dieses Objekts, die den Wert NULL haben
     */
    public function remove() : void
    {
        $properties = get_object_vars($this);
        foreach ($properties as $name => $value) {
            if ($value === null) {
                unset($this->{$name});
            }
        }
    }
}