<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Entity\Wsse;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Datenobjekt für die RequestSecurityToken Methode eines Security Token Webservices (utf-8)
 * Diese Klasse wird als Parameter an die RequestSecurityToken Methode übergeben
 *
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.wsse
 * @since 2016-03-03
 * @version
 */
class RequestSecurityToken implements BiPROEntity
{
    /**
     * TokenType
     * @var null|\SoapVar
     */
    protected $TokenType;
    
    /**
     * RequestType
     * @var null|\SoapVar
     */
    protected $RequestType;
    
    /**
     * Liefert den TokenType
     * @return null|\SoapVar
     */
    public function getTokenType() : ?\SoapVar
    {
        return $this->TokenType;
    }
    
    /**
     * Setzt den TokenType
     * @param \SoapVar $oTokenType
     */
    public function setTokenType(\SoapVar $oTokenType) : RequestSecurityToken
    {
        $this->TokenType = $oTokenType;
        return $this;
    }
    
    /**
     * Liefert den RequestType
     * @return null|\SoapVar
     */
    public function getRequestType() : ?\SoapVar
    {
        return $this->RequestType;
    }
    
    /**
     * Setzt den RequestType
     * @param \SoapVar $oRequestType
     * @return RequestSecurityToken
     */
    public function setRequestType(\SoapVar $oRequestType) : RequestSecurityToken
    {
        $this->RequestType = $oRequestType;
        return $this;
    }
    
    /**
     * Liefert dieses Entity als SoapVar
     * @return \SoapVar
     */
    public function encode() : \SoapVar
    {
        $oEncodedObject = new \SoapVar(
            $this,
            SOAP_ENC_OBJECT,
            '',
            '',
            'RequestSecurityToken',
            'http://schemas.xmlsoap.org/ws/2005/02/trust'
        );
        
        return $oEncodedObject;
    }
}