<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Entity\Wsse;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * UsernameToken Entity (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.wsse
 * @since 2016-03-03
 * @version
 */
class UsernameToken implements BiPROEntity 
{
	/**
	 * Username
	 * @var null|\SoapVar
	 */
	protected $Username;
	
	/**
	 * Password
	 * @var null|\SoapVar
	 */
	protected $Password;
	
	/**
	 * Liefert den Benutzernamen
	 * @return null|\SoapVar
	 */
	public function getUsername() : ?\SoapVar
	{
		return $this->Username;
	}
	
	/**
	 * Setzt den Benutzernamen
	 * @param \SoapVar $oUsername
	 * @return UsernameToken
	 */
	public function setUsername(\SoapVar $oUsername) : UsernameToken
	{
		$this->Username = $oUsername;
		return $this;
	}
	
	/**
	 * Liefert das Passwort
	 * @return null|\SoapVar
	 */
	public function getPassword() : ?\SoapVar
	{
		return $this->Password;
	}
	
	/**
	 * Setzt das Passwort
	 * @param \SoapVar $oPassword
	 * @return UsernameToken
	 */
	public function setPassword(\SoapVar $oPassword) : UsernameToken
	{
		$this->Password = $oPassword;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() : \SoapVar
	{
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			'',
		    'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd',
			'UsernameToken',
			'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd'
		);
	
		return $oEncodedObject;
	}
}