<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Entity\Wsse;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Lifetime Model nach BiPRO Norm 410 (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.wsse
 * @since 2016-03-03
 * @version
 */
class Lifetime implements BiPROEntity 
{
	
	/**
	 * Created
	 * @var null|\SoapVar
	 */
	protected $Created;
	
	/**
	 * Expires
	 * @var null|\SoapVar
	 */
	protected $Expires;
	
	/**
	 * Liefert die Beginnzeit des Security Tokens
	 * @return null|\SoapVar
	 */
	public function getCreated() : ?\SoapVar
	{
	    return $this->Created;
	}
	
	/**
	 * Setzt die Beginnzeit des Security Tokens
	 * @param \SoapVar $sCreated
	 * @return Lifetime
	 */
	public function setCreated(\SoapVar $oCreated) : Lifetime
	{
		$this->Created = $oCreated;
		return $this;
	}
	
	/**
	 * Liefert die Beginnzeig des Security Tokens
	 * @return null|\SoapVar
	 */
	public function getExpires() : ?\SoapVar
	{
	    return $this->Expires;
	}
	
	/**
	 * Setzt die Beginnzeit des Security Tokens
	 * @param \SoapVar $sExpires
	 * @return Lifetime
	 */
	public function setExpires(\SoapVar $oExpires) : Lifetime
	{
		$this->Expires = $oExpires;
		return $this;
	}
	
	/**
	 * Liefert dieses Entity als SoapVar
	 * @return \SoapVar
	 */
	public function encode() : \SoapVar
	{
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			'',
			'',
			'Lifetime',
			'http://schemas.xmlsoap.org/ws/2005/02/trust'
		);
	
		return $oEncodedObject;
	}
}