<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Entity\Wsse;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * RequestSecurityTokenResponse Entity nach BiPRO Norm (utf-8)
 *
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.wsse
 * @since 2016-03-03
 * @version
 */
class RequestSecurityTokenResponse implements BiPROEntity 
{
	/**
	 * TokenType
	 * @var null|\SoapVar
	 */
	protected $TokenType;

	/**
	 * Lifetime
	 * @var null|\SoapVar
	 */
	protected $Lifetime;

	/**
	 * RequestSecurityToken
	 * @var null|\SoapVar
	 */
	protected $RequestedSecurityToken;

	/**
	 * BiPROVersion
	 * @var null|\SoapVar
	 */
	protected $BiPROVersion;

	/**
	 * Liefert den TokenType Knoten
	 * @return null|\SoapVar
	 */
	public function getTokenType() : ?\SoapVar 
	{
		return $this->TokenType;
	}

	/**
	 * Setzt den TokenType Knoten
	 * @param \SoapVar $oTokenType
	 * @return RequestSecurityTokenResponse
	 */
	public function setTokenType(\SoapVar $oTokenType) : RequestSecurityTokenResponse
	{
		$this->TokenType = $oTokenType;
		return $this;
	}

	/**
	 * Liefert den Lifetime Knoten
	 * @return null|\SoapVar
	 */
	public function getLifetime() : ?\SoapVar
	{
		return $this->Lifetime;
	}

	/**
	 * Setzt den Lifetime Knoten
	 * @param \SoapVar $oLifetime
	 */
	public function setLifetime(\SoapVar $oLifetime) : RequestSecurityTokenResponse 
	{
		$this->Lifetime = $oLifetime;
		return $this;
	}

	/**
	 * Liefert den RequestedSecurityToken Knoten
	 * @return null|\SoapVar
	 */
	public function getRequestedSecurityToken() : ?\SoapVar
	{
		return $this->RequestedSecurityToken;
	}

	/**
	 * Setzt den RequestedSecurityToken Knoten
	 * @param \SoapVar $oRequestedSecurityToken
	 * @return RequestSecurityTokenResponse
	 */
	public function setRequestedSecurityToken($oRequestedSecurityToken) : RequestSecurityTokenResponse
	{
		$this->RequestedSecurityToken = $oRequestedSecurityToken;
		return $this;
	}

	/**
	 * Liefert den BiPROVersion Knoten
	 * @return \SoapVar
	 */
	public function getBiPROVersion() : ?\SoapVar
	{
		return $this->BiPROVersion;
	}

	/**
	 * Setzt den BiPROVersion Knoten
	 * @param \SoapVar $oBiPROVersion
	 * @return RequestSecurityTokenResponse
	 */
	public function setBiPROVersion(\SoapVar $oBiPROVersion) : RequestSecurityTokenResponse
	{
		$this->BiPROVersion = $oBiPROVersion;
		return $this;
	}

	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() : \SoapVar
	{
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			'',
			'',
			'RequestSecurityTokenResponse',
			'http://schemas.xmlsoap.org/ws/2005/02/trust'
	    );

		return $oEncodedObject;
	}
}