<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Loader;

/**
 * Standard Autoloader (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage loader
 * @since 2016-03-03
 * @version
 */
class StandardAutoloader 
{	
	/**
	 * Classmap mit allen verfügbaren Klassen
	 * @var array
	 */
	protected $aClassMap = [];
	
	/**
	 * Setzt die Classmap
	 * @param array $aClassMap
	 * @return void
	 */
	public function addClassMap(array $aClassMap = []) : void
	{
		$this->aClassMap = array_merge($this->aClassMap, $aClassMap);
	}
	
	/**
	 * Liefert eine neue Instanz der aufgerufenen Klasse
	 * @param string $sClass
	 * @return void
	 */
	public function autoload(string $sClass) : void
	{
		if (isset($this->aClassMap[$sClass])) {
			include $this->aClassMap[$sClass];
		}
	}
	
	/**
	 * Registriert diese Autoloader Klasse im SPL Autoload Stack
	 * qreturn void
	 */
	public function register() : void
	{
		spl_autoload_extensions('.php');
		spl_autoload_register([$this, 'autoload']);
	}
}