<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Entity\Basis;

/**
 * Master-Objekt. Von diesem Datentypen werden alle anderen komplexen Datentypen der BiPRO direkt oder indirekt abgeleitet.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.basis
 * @since 2018-10-07
 * @version 2.6.0
 */
abstract class Objekt
{
    /**
     * Erweiterung
     * @var null|Erweiterung
     */
    protected $Erweiterung;
    
    /**
     * Liefert die Erweiterung
     * @return Erweiterung|NULL
     */
    public function getErweiterung() : ?Erweiterung
    {
        return $this->Erweiterung;
    }
    
    /**
     * Setzt die Erweiterung
     * @param \SoapVar $oErweiterung
     * @return Objekt
     */
    public function setErweiterung(\SoapVar $oErweiterung) : Objekt
    {
        $this->Erweiterung = $oErweiterung;
        return $this;
    }
}