<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Entity\Wsse;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * SecurityContextToken Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.wsse
 * @since 2016-03-03
 * @version
 */
class SecurityContextToken implements BiPROEntity 
{
	/**
	 * Identifier
	 * @var null|\SoapVar
	 */
	protected $Identifier;
	
	/**
	 * Liefert den Identifier
	 * @return null|\SoapVar
	 */
	public function getIdentifier() : ?\SoapVar
	{
		return $this->Identifier;
	}
	
	/**
	 * Setzt den Identifier
	 * @param \SoapVar $oIdentifer
	 * @return SecurityContextToken
	 */
	public function setIdentifier(\SoapVar $oIdentifer) : SecurityContextToken
	{
		$this->Identifier = $oIdentifer;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() : \SoapVar
	{
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			'',
			'',
			'SecurityContextToken',
			'http://schemas.xmlsoap.org/ws/2005/02/sc'
		);
		
		return $oEncodedObject;
	}
}