<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Entity\Nachrichten;

use MMNewmedia\BiPRO\Entity\Basis\Objekt;
use MMNewmedia\BiPRO\Entity\BiPROEntity;
use MMNewmedia\BiPRO\Entity\NullProperties;

/**
 * Prozess-Objekt. Alle Antwort-Nachrichten inerhalb der von der BiPRO definierten Prozesse werden von diesem Datentypen abgeleitet.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.nachrichten
 * @since 2018-10-07
 * @version
 */
class ProzessAntwort extends Objekt implements BiPROEntity
{
    use NullProperties;
    
    /**
     * BiPRO Version
     * @var \SoapVar
     * @internal ST_Version
     */
    protected $BiPROVersion;
    
    /**
     * Eindeutige (providerspezifische) Identifizierung des anfragenden Systems (bzw. des Service Consumers)
     * @var \SoapVar
     * @interal ST_Text050
     */
    protected $ConsumerID;
    
    /**
     * Status Objekt
     * @var \SoapVar
     * @internal CT_Status
     */
    protected $Status;
    
    /**
     * Liefert die BiPROVersion
     * @return \SoapVar|NULL
     */
    public function getBiPROVersion() : ?\SoapVar
    {
        return $this->BiPROVersion;
    }
    
    /**
     * Setzt die BiPRO Version
     * @param \SoapVar $BiPROVersion
     * @return ProzessAntwort
     */
    public function setBiPROVersion(\SoapVar $BiPROVersion) : ProzessAntwort
    {
        $this->BiPROVersion = $BiPROVersion;
        return $this;
    }
    
    /**
     * Liefert die eindeutige Identifizierung des anfragenden Systems
     * @return \SoapVar|NULL
     */
    public function getConsumerID() : ?\SoapVar
    {
        return $this->ConsumerID;
    }
    
    /**
     * Setzt die eindeutige Identifizierung des anfragenden Systems
     * @param \SoapVar $oConsumerID
     * @return ProzessAntwort
     */
    public function setConsumerID(\SoapVar $oConsumerID) : ProzessAntwort
    {
        $this->ConsumerID = $oConsumerID;
        return $this;
    }
    
    /**
     * Liefert das Status Objekt
     * @return \SoapVar|NULL
     */
    public function getStatus() : ?\SoapVar
    {
        return $this->Status;
    }
    
    /**
     * Setzt das Status Objekt
     * @param \SoapVar $oStatus
     * @return ProzessAntwort
     */
    public function setStatus(\SoapVar $oStatus) : ProzessAntwort
    {
        $this->Status = $oStatus;
        return $this;
    }
    
    /**
     * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
     */
    public function encode() 
    {
        // Entfernen von NULL Eigenschaften über das NullProperties Trait
        $this->remove();
        
        $oEncodedObject = new \SoapVar(
            $this,
            SOAP_ENC_OBJECT,
            '',
            '',
            'ProzessAntwort',
            'http://www.bipro.net/namespace/nachrichten'
        );
        
        return $oEncodedObject;
    }
}