<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Entity\Nachrichten;

use MMNewmedia\BiPRO\Entity\Basis\Objekt;
use MMNewmedia\BiPRO\Entity\BiPROEntity;
use MMNewmedia\BiPRO\Entity\NullProperties;

/**
 * Prozess-Objekt. Dient der Übermittlung von Prozessfehlern. (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.nachrichten
 * @since 2018-10-07
 * @version
 */
class ProzessFehler extends Objekt implements BiPROEntity
{
    use NullProperties;
    
    /**
     * BiPRO Version
     * @var \SoapVar
     * @internal ST_Version
     */
    protected $BiPROVersion;
    
    /**
     * Status Objekt
     * @var \SoapVar
     * @internal CT_Status
     */
    protected $Status;
    
    /**
     * Liefert die BiPROVersion
     * @return \SoapVar|NULL
     */
    public function getBiPROVersion() : ?\SoapVar
    {
        return $this->BiPROVersion;
    }
    
    /**
     * Setzt die BiPRO Version
     * @param \SoapVar $BiPROVersion
     * @return ProzessFehler
     */
    public function setBiPROVersion(\SoapVar $BiPROVersion) : ProzessFehler
    {
        $this->BiPROVersion = $BiPROVersion;
        return $this;
    }
    
    /**
     * Liefert das Status Objekt
     * @return \SoapVar|NULL
     */
    public function getStatus() : ?\SoapVar
    {
        return $this->Status;
    }
    
    /**
     * Setzt das Status Objekt
     * @param \SoapVar $oStatus
     * @return ProzessFehler
     */
    public function setStatus(\SoapVar $oStatus) : ProzessFehler
    {
        $this->Status = $oStatus;
        return $this;
    }
    
    /**
     * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
     */
    public function encode() : \SoapVar
    {
        // Entfernen von NULL Eigenschaften über das NullProperties Trait
        $this->remove();
        
        $oEncodedObject = new \SoapVar(
            $this,
            SOAP_ENC_OBJECT,
            '',
            '',
            'ProzessFehler',
            'http://www.bipro.net/namespace/nachrichten'
        );
        
        return $oEncodedObject;
    }
}