<?php
declare(strict_types=1);
namespace MMNewmedia\BiPRO\Entity\Wsse;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * RequestedSecurityToken Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.wsse
 * @since 2013-03-03
 * @version
 */
class RequestedSecurityToken implements BiPROEntity 
{	
	/**
	 * SecurityContextToken
	 * @var null|\SoapVar
	 */
	protected $SecurityContextToken;
	
	/**
	 * Liefert den SecurityContextToken
	 * @return null|\SoapVar
	 */
	public function getSecurityContextToken() : ?\SoapVar
	{
		return $this->SecurityContextToken;
	}
	
	/**
	 * Setzt den SecurityContextToken
	 * @param \SoapVar $oSecurityContextToken
	 * @return RequestedSecurityToken
	 */
	public function setSecurityContextToken(\SoapVar $oSecurityContextToken) : RequestedSecurityToken
	{
		$this->SecurityContextToken = $oSecurityContextToken;
		return $this;
	}
	
	/**
	 * Liefert dieses Entity als SoapVar
	 * @return \SoapVar
	 */
	public function encode() : \SoapVar
	{
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			'',
			'',
			'RequestedSecurityToken',
			'http://schemas.xmlsoap.org/ws/2005/02/trust'
		);
		
		return $oEncodedObject;
	}
}