<?php
namespace MMNewmedia\BiPRO\Entity\Partner;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Adresse Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity
 * @since 2016-10-17
 * @version
 */
class Adresse implements BiPROEntity {
	
	/**
	 * Strasse
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $Strasse;
	
	/**
	 * Hausnummer
	 * @var \SoapVar
	 * @internal ST_Text017
	 */
	protected $Hausnummer;
	
	/**
	 * Postleitzahl
	 * @var \SoapVar
	 * @internal ST_Postleitzahl
	 */
	protected $Postleitzahl;
	
	/**
	 * Ort
	 * Wohnort bzw. Firmensitz
	 * @var \SoapVar
	 * @internal ST_Text025
	 */
	protected $Ort;
	
	/**
	 * Land
	 * @var \SoapVar
	 * @internal ST_Laenderkennzeichen
	 */
	protected $Land;
	
	/**
	 * Landname
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $Landname;
	
	/**
	 * Liefert die Straße
	 * @return SoapVar
	 */
	public function getStrasse() {
		return $this->Strasse;
	}
	
	/**
	 * Setzt die Straße
	 * @param \SoapVar $oStrasse
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Adresse
	 */
	public function setStrasse(\SoapVar $oStrasse) {
		$this->Strasse = $oStrasse;
		return $this;
	}
	
	/**
	 * Liefert die Hausnummer
	 * @return SoapVar
	 */
	public function getHausnummer() {
		return $this->Hausnummer;
	}
	
	/**
	 * Setzt die Hausnummer
	 * @param \SoapVar $oHausnummer
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Adresse
	 */
	public function setHausnummer(\SoapVar $oHausnummer) {
		$this->Hausnummer = $oHausnummer;
		return $this;
	}
	
	/**
	 * Liefert die Postleitzahl
	 * @return SoapVar
	 */
	public function getPostleitzahl() {
		return $this->Postleitzahl;
	}
	
	/**
	 * Setzt die postleitzahl
	 * @param \SoapVar $oPostleitzahl
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Adresse
	 */
	public function setPostleitzahl(\SoapVar $oPostleitzahl) {
		$this->Postleitzahl = $oPostleitzahl;
		return $this;
	}
	
	/**
	 * Liefert den Ort
	 * @return SoapVar
	 */
	public function getOrt() {
		return $this->Ort;
	}
	
	/**
	 * Setzt den Ort
	 * @param \SoapVar $oOrt
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Adresse
	 */
	public function setOrt(\SoapVar $oOrt) {
		$this->Ort = $oOrt;
		return $this;
	}
	
	/**
	 * Liefert die Länderkennung
	 * @return SoapVar
	 */
	public function getLand() {
		return $this->Land;
	}
	
	/**
	 * Setzt die Länderkennung
	 * @param \SoapVar $oLand
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Adresse
	 */
	public function setLand(\SoapVar $oLand) {
		$this->Land = $oLand;
		return $this;
	}
	
	/**
	 * Liefert den Namen des Landes
	 * @return SoapVar
	 */
	public function getLandname() {
		return $this->Landname;
	}
	
	/**
	 * Setzt den Namen des Landes
	 * @param \SoapVar $oLandname
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Adresse
	 */
	public function setLandname(\SoapVar $oLandname) {
		$this->Landname = $oLandname;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/partner',
			'Adresse',
			'http://www.bipro.net/namespace/partner'
		);
	
		return $oEncodedObject;
	}
}