<?php
namespace MMNewmedia\BiPRO\Entity;

/**
 * RequestSecurityTokenResponse Entity nach BiPRO Norm (utf-8)
 *
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity
 * @since 2016-03-03
 * @version
 */
class RequestSecurityTokenResponse {

	/**
	 * TokenType
	 * @var \SoapVar
	 */
	protected $TokenType;

	/**
	 * Lifetime
	 * @var \SoapVar
	 */
	protected $Lifetime;

	/**
	 * RequestSecurityToken
	 * @var \SoapVar
	 */
	protected $RequestedSecurityToken;

	/**
	 * BiPROVersion
	 * @var \SoapVar
	 */
	protected $BiPROVersion;

	/**
	 * Liefert den TokenType Knoten
	 * @return \SoapVar
	 */
	public function getTokenType() {
		return $this->TokenType;
	}

	/**
	 * Setzt den TokenType Knoten
	 * @param \SoapVar $oTokenType
	 */
	public function setTokenType($oTokenType) {
		$this->TokenType = $oTokenType;
	}

	/**
	 * Liefert den Lifetime Knoten
	 * @return \SoapVar
	 */
	public function getLifetime() {
		return $this->Lifetime;
	}

	/**
	 * Setzt den Lifetime Knoten
	 * @param \SoapVar $oLifetime
	 */
	public function setLifetime($oLifetime) {
		$this->Lifetime = $oLifetime;
	}

	/**
	 * Liefert den RequestedSecurityToken Knoten
	 * @return \SoapVar
	 */
	public function getRequestedSecurityToken() {
		return $this->RequestedSecurityToken;
	}

	/**
	 * Setzt den RequestedSecurityToken Knoten
	 * @param \SoapVar $oRequestedSecurityToken
	 */
	public function setRequestedSecurityToken($oRequestedSecurityToken) {
		$this->RequestedSecurityToken = $oRequestedSecurityToken;
	}

	/**
	 * Liefert den BiPROVersion Knoten
	 * @return \SoapVar
	 */
	public function getBiPROVersion() {
		return $this->BiPROVersion;
	}

	/**
	 * Setzt den BiPROVersion Knoten
	 * @param \SoapVar $oBiPROVersion
	 */
	public function setBiPROVersion($oBiPROVersion) {
		$this->BiPROVersion = $oBiPROVersion;
	}

	/**
	 * Liefert dieses Entity als SoapVar
	 * @return \SoapVar
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
				$this,
				SOAP_ENC_OBJECT,
				null,
				'http://schemas.xmlsoap.org/ws/2005/02/trust',
				'RequestSecurityTokenResponse',
				'http://schemas.xmlsoap.org/ws/2005/02/trust'
				);

		return $oEncodedObject;
	}
}