<?php
namespace MMNewmedia\BiPRO\Entity\Allgemein;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Datei Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.allgemein
 * @since 2016-10-17
 * @version
 */
class Datei implements BiPROEntity {
	
	/**
	 * Dateityp
	 * @var \SoapVar
	 * @internal ST_Dateityp
	 */
	protected $Dateityp;
	
	/**
	 * Dateiformat
	 * @var \SoapVar
	 * @internal ST_Dateiformat
	 */
	protected $Dateiformat;
	
	/**
	 * Dateiname
	 * @var \SoapVar
	 * @internal ST_Text255
	 */
	protected $Dateiname;
	
	/**
	 * Komprimierungstyp
	 * @var \SoapVar
	 * @internal ST_Komprimierungstyp
	 */
	protected $Komprimierungstyp;
	
	/**
	 * Prüfsummentyp
	 * @var \SoapVar
	 * @internal ST_Pruefsummetyp
	 */
	protected $Pruefsummetyp;
	
	/**
	 * Prüfsumme
	 * @var \SoapVar
	 * @internal ST_Pruefsumme
	 */
	protected $Pruefsumme;
	
	/**
	 * Datenlink
	 * @var \SoapVar
	 * @internal ST_Text255
	 */
	protected $Datenlink;
	
	/**
	 * Daten
	 * @var \SoapVar
	 * @internal ST_BinaereDaten
	 */
	protected $Daten;
	
	/**
	 * Liefert den Dateityp
	 * @return \SoapVar
	 */
	public function getDateityp() {
		return $this->Dateityp;
	}
	
	/**
	 * Setzt den Dateityp
	 * @param \SoapVar $oDateityp
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Datei
	 */
	public function setDateityp(\SoapVar $oDateityp) {
		$this->Dateityp = $oDateityp;
		return $this;
	}
	
	/**
	 * Liefert das Dateiformat
	 * @return \SoapVar
	 */
	public function getDateiformat() {
		return $this->Dateiformat;
	}
	
	/**
	 * Setzt das Dateiformat
	 * @param \SoapVar $oDateiformat
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Datei
	 */
	public function setDateiformat(\SoapVar $oDateiformat) {
		$this->Dateiformat = $oDateiformat;
		return $this;
	}
	
	/**
	 * Liefert den Dateinamen
	 * @return \SoapVar
	 */
	public function getDateiname() {
		return $this->Dateiname;
	}
	
	/**
	 * Setzt den Dateinamen
	 * @param \SoapVar $oDateiname
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Datei
	 */
	public function setDateiname(\SoapVar $oDateiname) {
		$this->Dateiname = $oDateiname;
		return $this;
	}
	
	/**
	 * Liefert den Komprimierungstyp
	 * @return \SoapVar
	 */
	public function getKomprimierungstyp() {
		return $this->Komprimierungstyp;
	}
	
	/**
	 * Setzt den Komprimierungstyp
	 * @param \SoapVar $oKomprimierungstyp
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Datei
	 */
	public function setKomprimierungstyp(\SoapVar $oKomprimierungstyp) {
		$this->Komprimierungstyp = $oKomprimierungstyp;
		return $this;
	}
	
	/**
	 * Liefert den Prüfsummentyp
	 * @return \SoapVar
	 */
	public function getPruefsummetyp() {
		return $this->Pruefsummetyp;
	}
	
	/**
	 * Setzt den Prüfsummentyp
	 * @param \SoapVar $oPruefsummetyp
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Datei
	 */
	public function setPruefsummetyp(\SoapVar $oPruefsummetyp) {
		$this->Pruefsummetyp = $oPruefsummetyp;
		return $this;
	}
	
	/**
	 * Liefert die Prüfsumme
	 * @return \SoapVar
	 */
	public function getPruefsumme() {
		return $this->Pruefsumme;
	}
	
	/**
	 * Setzt die Prüfsumme
	 * @param \SoapVar $oPruefsumme
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Datei
	 */
	public function setPruefsumme(\SoapVar $oPruefsumme) {
		$this->Pruefsumme = $oPruefsumme;
		return $this;
	}
	
	/**
	 * Liefert den Datenlink
	 * @return \SoapVar
	 */
	public function getDatenlink() {
		return $this->Datenlink;
	}
	
	/**
	 * Setzt den Datenlink
	 * @param \SoapVar $oDatenlink
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Datei
	 */
	public function setDatenlink(\SoapVar $oDatenlink) {
		$this->Datenlink = $oDatenlink;
		return $this;
	}
	
	/**
	 * Liefert die binären Daten
	 * @return \SoapVar
	 */
	public function getDaten() {
		return $this->Daten;
	}
	
	/**
	 * Setzt die binären Daten
	 * @param \SoapVar $oDaten
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Datei
	 */
	public function setDaten(\SoapVar $oDaten) {
		$this->Daten = $oDaten;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/allgemein',
			'Datei',
			'http://www.bipro.net/namespace/allgemein'
		);
	
		return $oEncodedObject;
	}
}