<?php
namespace MMNewmedia\BiPRO\Entity\Partner;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

class Bankverbindung implements BiPROEntity {
	
	/**
	 * Art der Bankverbindung
	 * @var \SoapVar
	 * @internal ST_TypDerBankverbindung
	 */
	protected $ArtID;
	
	/**
	 * Kontonummer
	 * @var \SoapVar
	 * @internal ST_Kontonummer
	 */
	protected $Kontonummer;
	
	/**
	 * Bankleitzahl
	 * @var \SoapVar
	 * @internal ST_Bankleitzahl
	 */
	protected $Bankleitzahl;
	
	/**
	 * Kontoinhaber
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $Kontoinhaber;
	
	/**
	 * Geldinstitut
	 * Name der Bank oder Sparkasse
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $Institut;
	
	/**
	 * IBAN
	 * International Bank Account Number
	 * @var \SoapVar
	 * @internal ST_IBAN
	 */
	protected $IBAN;
	
	/**
	 * BIC
	 * Bank Identication Code
	 * @var \SoapVar
	 * @internal ST_BIC
	 */
	protected $BIC;
	
	/**
	 * Liefert die ArtID
	 * @return \SoapVar
	 */
	public function getArtID() {
		return $this->ArtID;
	}
	
	/**
	 * Setzt die ArtID
	 * @param \SoapVar $oArtID
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Bankverbindung
	 */
	public function setArtID(\SoapVar $oArtID) {
		$this->ArtID = $oArtID;
		return $this;
	}
	
	/**
	 * Liefert die Kontonummer
	 * @return\ SoapVar
	 */
	public function getKontonummer() {
		return $this->Kontonummer;
	}
	
	/**
	 * Setzt die Kontonummer
	 * @param \SoapVar $oKontonummer
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Bankverbindung
	 */
	public function setKontonummer(\SoapVar $oKontonummer) {
		$this->Kontonummer = $oKontonummer;
		return $this;
	}
	
	/**
	 * Liefert die Bankleitzahl
	 * @return \SoapVar
	 */
	public function getBankleitzahl() {
		return $this->Bankleitzahl;
	}
	
	/**
	 * Setzt die Bankleitzahl
	 * @param \SoapVar $oBankleitzahl
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Bankverbindung
	 */
	public function setBankleitzahl(\SoapVar $oBankleitzahl) {
		$this->Bankleitzahl = $oBankleitzahl;
		return $this;
	}
	
	/**
	 * Liefert den Kontoinhaber
	 * @return \SoapVar
	 */
	public function getKontoinhaber() {
		return $this->Kontoinhaber;
	}
	
	/**
	 * Setzt den Kontoinhaber
	 * @param \SoapVar $oKontoinhaber
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Bankverbindung
	 */
	public function setKontoinhaber(\SoapVar $oKontoinhaber) {
		$this->Kontoinhaber = $oKontoinhaber;
		return $this;
	}
	
	/**
	 * Liefert das Institut
	 * @return \SoapVar
	 */
	public function getInstitut() {
		return $this->Institut;
	}
	
	/**
	 * Setzt das Institut
	 * @param \SoapVar $oInstitut
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Bankverbindung
	 */
	public function setInstitut(\SoapVar $oInstitut) {
		$this->Institut = $oInstitut;
		return $this;
	}
	
	/**
	 * Liefert die IBAN
	 * @return \SoapVar
	 */
	public function getIban() {
		return $this->IBAN;
	}
	
	/**
	 * Setzt die IBAN
	 * @param \SoapVar $oIban
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Bankverbindung
	 */
	public function setIban(\SoapVar $oIban) {
		$this->IBAN = $oIban;
		return $this;
	}
	
	/**
	 * Liefert die BIC
	 * @return \SoapVar
	 */
	public function getBic() {
		return $this->BIC;
	}
	
	/**
	 * Setzt die BIC
	 * @param \SoapVar $oBic
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Bankverbindung
	 */
	public function setBic(\SoapVar $oBic) {
		$this->BIC = $oBic;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/partner',
			'Bankverbindung',
			'http://www.bipro.net/namespace/partner'
		);
	
		return $oEncodedObject;
	}
}