<?php
namespace MMNewmedia\BiPRO\Norm420\Model;

use MMNewmedia\BiPRO\Norm420\Entity\Security;

/**
 * Wsse Header für Requests nach BiPRO Norm 420 (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage norm420.entity
 * @since 2016-10-20
 * @version
 */
class WsseHeader extends \SoapHeader {
	
	/**
	 * WSSE Namensraum
	 * @var string
	 */
	protected $sWsseNs = 'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd';
	
	/**
	 * Konstruktor
	 * 
	 * @param \SoapVar $oSecurityContextToken Das SecurityContextToken SoapVar Object, welches vom STS geliefert wurde
	 */
	public function __construct(\SoapVar $oSecurityContextToken) {
		$oSecurity = $this->getSecurityNode($oSecurityContextToken);
		parent::__construct($this->sWsseNs, 'Security', $oSecurity, true);
	}
	
	/**
	 * Erzeugt das Security Entity nach Norm 420 als SoapVar Objekt und liefert es aus
	 * 
	 * @param \SoapVar $oSecurityContextToken
	 * @return \SoapVar
	 */
	public function getSecurityNode(\SoapVar $oSecurityContextToken) {
		$oSecurity = new Security();
		$oSecurity->setSecurityContextToken($oSecurityContextToken);
		
		return $oSecurity->encode();
	}
}