<?php
namespace MMNewmedia\BiPRO\Norm410\Model;

use MMNewmedia\BiPRO\Entity\Lifetime;
use MMNewmedia\BiPRO\Entity\SecurityContextToken;
use MMNewmedia\BiPRO\Entity\RequestedSecurityToken;
use MMNewmedia\BiPRO\Entity\RequestSecurityTokenResponse;

/**
 * RequestSecurityToken Model Klasse (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage norm410.model
 * @since 2016-03-03
 * @version
 */
class Response {
	
	/**
	 * Setzt die Response zusammen
	 * 
	 * @return \SoapVar
	 */
	public function RequestSecurityToken() {
		
		// TokenType Knoten
		$oTokenType = new \SoapVar(
			'http://schemas.xmlsoap.org/ws/2005/02/sc/sct',
			XSD_STRING,
			null,
			null,
			'TokenType',
			'http://schemas.xmlsoap.org/soap/envelope/'
		);
		
		// Lifetime Knoten
		$oDateTime = new \DateTime();
		$oCreated = new \Soapvar(
			$oDateTime->format('Y-m-d H:i:s'),
			XSD_STRING,
			null,
			null,
			'Created',
			'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd'
		);
		
		$oDateTime->modify('+1 hour');
		$oExpires = new \SoapVar(
			$oDateTime->format('Y-m-d H:i:s'),
			XSD_STRING,
			null,
			null,
			'Expires',
			'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd'
		);
		
		$oLifetime = new Lifetime();
		$oLifetime->setCreated($oCreated);
		$oLifetime->setExpires($oExpires);
		$oLifetimeSoapVar = $oLifetime->encode();
		
		// RequestedSecurityToken Knoten
		$sHash = 'bipro:' . md5(microtime());
		$oIdentifier = new \SoapVar(
			$sHash,
			XSD_STRING,
			null,
			null,
			'Identifier',
			'http://schemas.xmlsoap.org/ws/2005/02/sc'
		);
		
		$oSecurityContextToken = new SecurityContextToken();
		$oSecurityContextToken->setIdentifier($oIdentifier);
		$oSecurityContextTokenSoapVar = $oSecurityContextToken->encode();
		
		$oRequestedSecurityToken = new RequestedSecurityToken();
		$oRequestedSecurityToken->setSecurityContextToken($oSecurityContextTokenSoapVar);
		$oRequestedSecurityTokenSoapVar = $oRequestedSecurityToken->encode();
		
		// BiPROVersion Knoten
		$oBiPROVersion = new \SoapVar(
			'2.1.0.1.0',
			XSD_STRING,
			null,
			null,
			'BiPROVersion',
			'http://www.bipro.net/namespace/allgemein'
		);
		
		$oRequestSecurityTokenResponse = new RequestSecurityTokenResponse();
		$oRequestSecurityTokenResponse->setTokenType($oTokenType);
		$oRequestSecurityTokenResponse->setLifetime($oLifetimeSoapVar);
		$oRequestSecurityTokenResponse->setRequestedSecurityToken($oRequestedSecurityTokenSoapVar);
		$oRequestSecurityTokenResponse->setBiPROVersion($oBiPROVersion);
		
		return $oRequestSecurityTokenResponse->encode();
	}
}