<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Dauer Entity nach BiPRO Norm (utf-8)
 * 
 * Monatsgenaue Angabe von Laufzeiten (auch unterjährig). Mindestens eines der Attribute LaufzeitJahre 
 * und LaufzeitMonate ist zu befuellen. Fehlt in der Nachricht eines der beiden, so wird hierfuer der 
 * Wert 0 angenommen, so kann zum Beispiel bei einer Laufzeit von genau einem Jahr die Angabe 
 * LaufzeitMonate weggelassen werden.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-17
 * @version
 */
class Dauer implements BiPROEntity {
	
	/**
	 * Laufzeit Jahre
	 * @var \SoapVar
	 * @internal ST_Ganzzahl
	 */
	protected $LaufzeitJahre;
	
	/**
	 * Laufzeit Monate
	 * @var \SoapVar
	 * @internal ST_Ganzzahl
	 */
	protected $LaufzeitMonate;
	
	/**
	 * Liefert die Laufzeit in Jahren
	 * @return \SoapVar
	 */
	public function getLaufzeitJahre() {
		return $this->LaufzeitJahre;
	}
	
	/**
	 * Setzt die Laufzeit in Jahren
	 * @param \SoapVar $oLaufzeitJahre
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Dauer
	 */
	public function setLaufzeitJahre(\SoapVar $oLaufzeitJahre) {
		$this->LaufzeitJahre = $oLaufzeitJahre;
		return $this;
	}
	
	/**
	 * Liefert die Laufzeit in Monaten
	 * @return \SoapVar
	 */
	public function getLaufzeitMonate() {
		return $this->LaufzeitMonate;
	}
	
	/**
	 * Setzt die Laufzeit in Monaten
	 * @param \SoapVar $oLaufzeitMonate
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Dauer
	 */
	public function setLaufzeitMonate(\SoapVar $oLaufzeitMonate) {
		$this->LaufzeitMonate = $oLaufzeitMonate;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Dauer',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}