<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

/**
 * Produkt Entity nach BiPRO Norm (utf-8)
 * Mittlere Ebene der Produkthierarchie gemaess VAA-Modell. Spartenspezifisch abzuleiten.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-17
 * @version
 */
class Produkt extends Produktbaustein {
	
	/**
	 * Sparte
	 * @var \SoapVar
	 * @internal ST_Parte
	 */
	protected $Sparte;
	
	/**
	 * Paket
	 * @var \SoapVar
	 * @internal STE_Paket
	 */
	protected $Paket;
	
	/**
	 * Liefert die Sparte
	 * @return \SoapVar
	 */
	public function getSparte() {
		return $this->Sparte;
	}
	
	/**
	 * Setzt die Sparte
	 * @param \SoapVar $oSparte
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Produkt
	 */
	public function setSparte(\SoapVar $oSparte) {
		$this->Sparte = $oSparte;
		return $this;
	}
	
	/**
	 * Liefert das Paket
	 * @return \SoapVar
	 */
	public function getPaket() {
		return $this->Paket;
	}
	
	/**
	 * Setzt das Paket
	 * @param \SoapVar $oPaket
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Produkt
	 */
	public function setPaket(\SoapVar $oPaket) {
		$this->Paket = $oPaket;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Produkt',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}