<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

/**
 * Elementarprodukt Entity nach BiPRo Norm (utf-8)
 * Unterste Ebene der Produkthierarchie gemaess VAA-Modell. Kleinste tariefierbare Einheit. 
 * Spartenspezifisch abzuleiten und zu benennen (z.B. Deckung, Tarif, etc.).
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-18
 * @version
 */
class Elementarprodukt extends Produkt {
	
	/**
	 * Fonds Portfolio
	 * @var \SoapVar
	 * @internal CT_FondsPortfolio
	 */
	protected $FondsPortfolio;
	
	/**
	 * Leistungsausschluss
	 * @var \SoapVar
	 * @internal CT_leistungsausschluss
	 */
	protected $Leistungsausschluss;
	
	/**
	 * Versicherungssumme oder Leistung
	 * @var \SoapVar
	 * @internal CT_VersicherungssummeOderLeistung
	 */
	protected $VersicherungssummeOderLeistung;
	
	/**
	 * Dynamik
	 * @var \SoapVar
	 * @internal CT_Dynamik
	 */
	protected $Dynamik;
	
	public function getFondsPortfolio() {
		return $this->FondsPortfolio;
	}
	
	public function setFondsPortfolio(\SoapVar $oFondsPortfolio) {
		$this->FondsPortfolio = $oFondsPortfolio;
		return $this->FondsPortfolio;
	}
	
	public function getLeistungsausschluss() {
		return $this->Leistungsausschluss;
	}
	
	public function setLeistungsausschluss(\SoapVar $oLeistungsausschluss) {
		$this->Leistungsausschluss = $oLeistungsausschluss;
		return $this;
	}
	
	public function getVersicherungssummeOderLeistung() {
		return $this->VersicherungssummeOderLeistung;
	}
	
	public function setVersicherungssummeOderLeistung(\SoapVar $oVersicherungssummeOderLeistung) {
		$this->VersicherungssummeOderLeistung = $oVersicherungssummeOderLeistung;
		return $this;
	}
	
	public function getDynamik() {
		return $this->Dynamik;
	}
	
	public function setDynamik(\SoapVar $oDynamik) {
		$this->Dynamik = $oDynamik;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Elementarprodukt',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}