<?php
namespace MMNewmedia\BiPRO\Entity\Partner\SHU;

use MMNewmedia\BiPRO\Entity\Partner\Partner as BiPROPartner;

/**
 * Erweiterung des Parter Entity für Janitos SHU (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage janitos.entity.partner
 * @since 2016-10-17
 * @version
 */
class Partner extends BiPROPartner {
	
	/**
	 * Berufsgruppe / Branche
	 * @var \SoapVar
	 * @internal ST_BerufBranche
	 */
	protected $Berufsgruppe;
	
	/**
	 * Kundennummer beim Versicherungsunternehmen
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $KundennummerVU;
	
	/**
	 * Liefert die Berufsgruppe
	 * @return \SoapVar
	 */
	public function getBerufsgruppe() {
		return $this->Berufsgruppe;
	}
	
	/**
	 * Setzt die Berufsgruppe
	 * @param \SoapVar $oBerufsgruppe
	 * @return \MMNewmedia\BiPRO\Janitos\Entity\Partner\Partner
	 */
	public function setBerufsgruppe(\SoapVar $oBerufsgruppe) {
		$this->Berufsgruppe = $oBerufsgruppe;
		return $this;
	}
	
	/**
	 * Liefert die Kundennummer des Versicherungsunternehmens
	 * @return \SoapVar
	 */
	public function getKundennummerVU() {
		return $this->KundennummerVU;
	}
	
	/**
	 * Setzt die Kundennummer des Versicherungsunternehmens
	 * @param \SoapVar $oKundennummerVU
	 * @return \MMNewmedia\BiPRO\Janitos\Entity\Partner\Partner
	 */
	public function setKundennummerVU(\SoapVar $oKundennummerVU) {
		$this->KundennummerVU = $oKundennummerVU;
		return $this;
	}
}