<?php
namespace MMNewmedia\BiPRO\Entity\Partner;

class Partneranschrift extends Adresse {
	
	/**
	 * Art der Anschrift
	 * @var \SoapVar
	 * @internal ST_Anschriftart
	 */
	protected $ArtID;
	
	/**
	 * Postfach
	 * @var \SoapVar
	 * @internal ST_Postfach
	 */
	protected $Postfach;
	
	/**
	 * Adresszusatz
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $Adresszusatz;
	
	/**
	 * Liefert die Art der Anschrift
	 * @return \SoapVar
	 */
	public function getArtID() {
		return $this->ArtID;
	}
	
	/**
	 * Setzt die Art der Anschrift
	 * @param \SoapVar $oArtID
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Partneranschrift
	 */
	public function setArtID(\SoapVar $oArtID) {
		$this->ArtID = $oArtID;
		return $this;
	}
	
	/**
	 * Liefert das Postfach
	 * @return \SoapVar
	 */
	public function getPostfach() {
		return $this->Postfach;
	}
	
	/**
	 * Setzt das Postfach
	 * @param \SoapVar $oPostfach
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Partneranschrift
	 */
	public function setPostfach(\SoapVar $oPostfach) {
		$this->Postfach = $oPostfach;
		return $this;
	}
	
	/**
	 * Liefert einen Adresszusatz
	 * @return \SoapVar
	 */
	public function getAdresszusatz() {
		return $this->Adresszusatz;
	}
	
	/**
	 * Setzt den Adresszusatz
	 * @param \SoapVar $oAdresszusatz
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Partneranschrift
	 */
	public function setAdresszusatz(\SoapVar $oAdresszusatz) {
		$this->Adresszusatz = $oAdresszusatz;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/partner',
			'Partneranschrift',
			'http://www.bipro.net/namespace/partner'
		);
	
		return $oEncodedObject;
	}
}