<?php
namespace MMNewmedia\BiPRO\Norm420\Entity;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Security Entity nach BiPRO Norm 420 (utf-8)
 * Das Security Objekt beinhaltet hier lediglich den Security Context Token inkl. Identifier
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage bipro.norm420.entity
 * @since 2016-10-20
 * @version
 */
class Security implements BiPROEntity {
	
	/**
	 * SecurityContextToken
	 * @var \SoapVar
	 */
	protected $SecurityContextToken;
	
	/**
	 * Liefert den Security Context Token
	 * @return \SoapVar
	 */
	public function getSecurityContextToken() {
		return $this->SecurityContextToken;
	}
	
	/**
	 * Setzt den Security Context Token
	 * @param \SoapVar $oSecurityContextToken
	 * @return \MMNewmedia\BiPRO\Norm420\Entity\Security
	 */
	public function setSecurityContextToken(\SoapVar $oSecurityContextToken) {
		$this->SecurityContextToken = $oSecurityContextToken;
		return $this;
	}
	
	/**
	 * Liefert dieses Entity als SoapVar
	 * @return \SoapVar
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Security',
			'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd'
		);
	
		return $oEncodedObject;
	}
}