<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * GetQuote Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewemdia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-17
 * @version
 */
class GetQuote implements BiPROEntity {
	
	/**
	 * Request
	 * @var \SoapVar
	 * @internal CT_QuoteRequest
	 */
	protected $Request;
	
	/**
	 * Liefert das Request
	 * @return \SoapVar
	 */
	public function getRequest() {
		return $this->Request;
	}
	
	/**
	 * Setzt das Request
	 * @param \SoapVar $oRequest
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\GetQuote
	 */
	public function setRequest(\SoapVar $oRequest) {
		$this->Request = $oRequest;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'getQuote',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}