<?php
namespace MMNewmedia\BiPRO\Entity\Allgemein;

/**
 * StatusRequest Entity nach BiPRO Norm (utf-8)
 * Daten für die Statusanfrage
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.allgemein
 * @since 2016-10-17
 * @version
 */
class StatusRequest extends ProzessAnfrage {
	
	/**
	 * Status
	 * @var \SoapVar
	 * @internal CT_Status
	 */
	protected $Status;
	
	/**
	 * Liefert den Status
	 * @return SoapVar
	 */
	public function getStatus() {
		return $this->Status;
	}
	
	/**
	 * Setzt den Status
	 * @param \SoapVar $oStatus
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\StatusRequest
	 */
	public function setStatus(\SoapVar $oStatus) {
		$this->Status = $oStatus;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\Allgemein\ProzessAnfrage::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/allgemein',
			'StatusRequest',
			'http://www.bipro.net/namespace/allgemein'
		);
	
		return $oEncodedObject;
	}
}