<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Produktbaustein Entity nach BiPRO Norm (utf-8)
 * Basisklasse aller Produktbausteine (Verkaufsprodukt, Produkt, Elementarprodukt) gemaess VAA-Modell.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-17
 * @version
 */
class Produktbaustein implements BiPROEntity {
	
	/**
	 * Beginn des Versicherungsschutzes
	 * @var \SoapVar
	 * @internal ST_Datum
	 */
	protected $Beginn;
	
	/**
	 * Ablauf des Versicherungsschutzes
	 * @var \SoapVar
	 * @internal ST_Datum
	 */
	protected $Ablauf;
	
	/**
	 * Eine für Menschen verständliche Bezeichnung des Elementarproduktes, Produktes oder
	 * Verkaufsproduktes. Nicht geeignet zur Schlüsselung von Produktbausteinen.
	 * @var \SoapVar
	 * @internal ST_Text255
	 */
	protected $Bezeichnung;
	
	/**
	 * Variante
	 * @var \SoapVar
	 * @internal STE_Variante
	 */
	protected $Variante;
	
	/**
	 * Tarifgeneration
	 * @var \SoapVar
	 * @inernal STE_Tarifgeneration
	 */
	protected $Tarifgeneration;
	
	/**
	 * Gewünschte Zahlungsweise
	 * @var \SoapVar
	 * @internal ST_Zahlungsweise
	 */
	protected $GewuenschteZahlungsweise;
	
	/**
	 * Kurzbeschreibung
	 * @var \SoapVar
	 * @internal ST_Text1000
	 */
	protected $Kurzbeschreibung;
	
	/**
	 * Das Attribut kann n-fach vorkommen, weil ein Produkt mehrere Bedingungswerke haben kann. Je
	 * Attribut wird eine Bedingung inkl. Bedingungsversion (z.B. VHB2005) geschlüsselt.
	 * @var \SoapVar
	 * @internal STE_Bedingungen
	 */
	protected $Bedingungen;
	
	/**
	 * Liefert den Versicherungsbeginn
	 * @return \SoapVar
	 */
	public function getBeginn() {
		return $this->Beginn;
	}
	
	/**
	 * Setzt den Versicherungsbeginn
	 * @param \SoapVar $oBeginn
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Produktbaustein
	 */
	public function setBeginn(\SoapVar $oBeginn) {
		$this->Beginn = $oBeginn;
		return $this;
	}
	
	/**
	 * Liefert den Versicherungsablauf
	 * @return \SoapVar
	 */
	public function getAblauf() {
		return $this->Ablauf;
	}
	
	/**
	 * Setzt den Versicherungsablauf
	 * @param \SoapVar $oAblauf
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Produktbaustein
	 */
	public function setAblauf(\SoapVar $oAblauf) {
		$this->Ablauf = $oAblauf;
		return $this;
	}
	
	/**
	 * Liefert die Bezeichnung
	 * @return \SoapVar
	 */
	public function getBezeichnung() {
		return $this->Bezeichnung;
	}
	
	/**
	 * Setzt die Bezeichnung
	 * @param \SoapVar $oBezeichnung
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Produktbaustein
	 */
	public function setBezeichnung(\SoapVar $oBezeichnung) {
		$this->Bezeichnung = $oBezeichnung;
		return $this;
	}
	
	/**
	 * Liefert die Variante
	 * @return \SoapVar
	 */
	public function getVariante() {
		return $this->Variante;
	}
	
	/**
	 * Setzt die Variante
	 * @param \SoapVar $oVariante
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Produktbaustein
	 */
	public function setVariante(\SoapVar $oVariante) {
		$this->Variante = $oVariante;
		return $this;
	}
	
	/**
	 * Liefert die Tarifgeneration
	 * @return \SoapVar
	 */
	public function getTarifgeneration() {
		return $this->Tarifgeneration;
	}
	
	/**
	 * Setzt die Tarifgeneration
	 * @param \SoapVar $oTarifgeneration
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Produktbaustein
	 */
	public function setTarifgeneration(\SoapVar $oTarifgeneration) {
		$this->Tarifgeneration = $oTarifgeneration;
		return $this;
	}
	
	/**
	 * Liefert die gewünschte Zahlungsweise
	 * @return \SoapVar
	 */
	public function getGewuenschteZahlungsweise() {
		return $this->GewuenschteZahlungsweise;
	}
	
	/**
	 * Setzt die gewünschte Zahlungsweise
	 * @param \SoapVar $oGewuenschteZahlungweise
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Produktbaustein
	 */
	public function setGewuenschteZahlungsweise(\SoapVar $oGewuenschteZahlungweise) {
		$this->GewuenschteZahlungsweise = $oGewuenschteZahlungweise;
		return $this;
	}
	
	/**
	 * Liefert eine Kurzbeschreibung
	 * @return \SoapVar
	 */
	public function getKurzbeschreibung() {
		return $this->Kurzbeschreibung;
	}
	
	/**
	 * Setzt eine Kurzbeschreibung
	 * @param \SoapVar $oKurzbeschreibung
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Produktbaustein
	 */
	public function setKurzbeschreibung(\SoapVar $oKurzbeschreibung) {
		$this->Kurzbeschreibung = $oKurzbeschreibung;
		return $this;
	}
	
	/**
	 * Liefert die Bedingungen
	 * @return \SoapVar
	 */
	public function getBedingungen() {
		return $this->Bedingungen;
	}
	
	/**
	 * Setzt die Bedingungen 
	 * @param \SoapVar $oBedingungen
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Produktbaustein
	 */
	public function setBedingungen(\SoapVar $oBedingungen) {
		$this->Bedingungen = $oBedingungen;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Produktbaustein',
			'http://www.bipro.net/namespace/tarifierung'
		);
		
		return $oEncodedObject;
	}
}