<?php
namespace MMNewmedia\BiPRO\Entity;

/**
 * UsernameToken Entity (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity
 * @since 2016-03-03
 * @version
 */
class UsernameToken implements BiPROEntity {
	/**
	 * Username
	 * @var \SoapVar
	 */
	protected $Username;
	
	/**
	 * Password
	 * @var \SoapVar
	 */
	protected $Password;
	
	/**
	 * Liefert den Benutzernamen
	 * @return \SoapVar
	 */
	public function getUsername()
	{
		return $this->Username;
	}
	
	/**
	 * Setzt den Benutzernamen
	 * @param \SoapVar $oUsername
	 */
	public function setUsername(\SoapVar $oUsername)
	{
		$this->Username = $oUsername;
	}
	
	/**
	 * Liefert das Passwort
	 * @return \SoapVar
	 */
	public function getPassword()
	{
		return $this->Password;
	}
	
	/**
	 * Setzt das Passwort
	 * @param \SoapVar $oPassword
	 */
	public function setPassword(\SoapVar $oPassword)
	{
		$this->Password = $oPassword;
	}
	
	/**
	 * Liefert dieses Entity als SoapVar
	 * @return \SoapVar
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd',
			'UsernameToken',
			'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd'
		);
	
		return $oEncodedObject;
	}
}