<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

use MMNewmedia\BiPRO\Entity\Allgemein\Geschaeftsvorgang;

/**
 * Angebot Entity nach BiPRO Norm (utf-8)
 * Geschaeftsvorgang Angebot. Darf nicht spartenspezifisch abgeleitet werden, da sonst die 
 * spartenuebergreifende Buendelung von Produkten nicht mehr moeglich waere.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-18
 * @version
 */
class Angebot extends Geschaeftsvorgang {
	
	/**
	 * Beitragszahler
	 * @var \SoapVar
	 * @internal CT_Beitragszahler
	 */
	protected $Beitragszahler;
	
	/**
	 * Liefert den Beitragszahler
	 * @return \SoapVar
	 */
	public function getBeitragszahler() {
		return $this->Beitragszahler;
	}
	
	/**
	 * Setzt den Beitragszahler
	 * @param \SoapVar $oBeitragszahler
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Angebot
	 */
	public function setBeitragszahler(\SoapVar $oBeitragszahler) {
		$this->Beitragszahler = $oBeitragszahler;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Angebot',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}