<?php
namespace MMNewmedia\BiPRO\Entity;

/**
 * Security Klasse nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity
 * @since 2015-10-10
 * @version
 */
class Security implements BiPROEntity {
	
	/**
	 * Objekt, welches den UsernameToken Knoten im Soap Request darstellen wird
	 * @var \SoapVar
	 */
	protected $UsernameToken;
	
	/**
	 * Liefert das UsernameToken Objekt
	 * @return \SoapVar
	 */
	public function getUsernameToken()
	{
		return $this->UsernameToken;
	}
	
	/**
	 * Setzt das UsernameToken Objekt
	 * @param \SoapVar $oUsernameToken
	 */
	public function setUsernameToken(\SoapVar $oUsernameToken)
	{
		$this->UsernameToken = $oUsernameToken;
	}
	
	/**
	 * Liefert dieses Entity als SoapVar
	 * @return \SoapVar
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd',
			'Security',
			'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd'
		);
	
		return $oEncodedObject;
	}
}