<?php
namespace MMNewmedia\BiPRO\Entity\Partner\SHU;

use MMNewmedia\BiPRO\Entity\Partner\Person AS BiPROPerson;

/**
 * SHU Erweiterung des BiPRO Person Entity (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.shu
 * @since 2016-10-17
 * @version
 */
class Person extends BiPROPerson {
	
	/**
	 * Art / Status der Tätigkeit
	 * @var \SoapVar
	 * @internal ST_Taetigkeitsstatus
	 */
	protected $Taetigkeitsstatus;
	
	/**
	 * Liefert den Tätigkeitsstatus
	 * @return \SoapVar
	 */
	public function getTaetigkeitsstatus() {
		return $this->Taetigkeitsstatus;
	}
	
	/**
	 * Setzt den Tätigkeitsstatus
	 * @param \SoapVar $oTaetigkeitsstatus
	 * @return \MMNewmedia\BiPRO\Entity\Partner\SHU\Person
	 */
	public function setTaetigkeitsstatus(\SoapVar $oTaetigkeitsstatus) {
		$this->Taetigkeitsstatus = $oTaetigkeitsstatus;
		return $this;
	}
}