<?php
namespace MMNewmedia\BiPRO\Norm410\Model;

use MMNewmedia\BiPRO\Entity\SecurityContextToken;
use MMNewmedia\BiPRO\Entity\Lifetime;

/**
 * RequestSecurityTokenResponse Entity nach BiPRO Norm (utf-8)
 * Wertet die RequestSecurtiyToken Response eines BiPRO Security Token Webservices aus
 *
 * @author Marcel MaaÃŸ <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity
 * @since 2016-10-20
 * @version
 */
class RequestSecurityTokenResponseType {

	/**
	 * Liefert den SecurityContextToken Knoten als SoapVar für die weitere Verwendung
	 * @return \SoapVar
	 */
	public function getSecurityContextToken() {
		$oIdentifier = new \SoapVar(
			$this->any['RequestedSecurityToken']->any,
			XSD_STRING,
			null,
			null,
			'Identifier',
			'http://schemas.xmlsoap.org/ws/2005/02/sc'
		);

		$oSecurityContextToken = new SecurityContextToken();
		$oSecurityContextToken->setIdentifier($oIdentifier);

		return $oSecurityContextToken->encode();
	}

	/**
	 * Liefert den BiPRO Security Token Identifier
	 * @return string
	 */
	public function getIdentifier() {
		return $this->any['RequestedSecurityToken']->any;
	}

	/**
	 * Liefert den Token Type
	 * @return string
	 */
	public function getTokenType() {
		return $this->any['TokenType'];
	}

	/**
	 * Liefert das Lifetime Entity mit den Daten aus der Response
	 * @return \MMNewmedia\BiPRO\Entity\Lifetime
	 */
	public function getLifetime() {
		$oLifetime = new Lifetime();
		$oLifetime->setCreated($this->any['Lifetime']->Created->_)
			->setExpires($this->any['Lifetime']->Expires->_);

		return $oLifetime;
	}
}