<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Beitrag Entity nach BiPRO Norm (utf-8)
 * Zu zahlende, vorgegebene oder berechnete Beiträge.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewemdia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-18
 * @version
 */
class Beitrag implements BiPROEntity {
	
	/**
	 * Art des Beitrags
	 * @var \SoapVar
	 * @internal ST_Beitrag
	 */
	protected $ArtID;
	
	/**
	 * Beitrag gemäß angegebener Währung
	 * @var \SoapVar
	 * @internal ST_Betrag
	 */
	protected $Betrag;
	
	/**
	 * Währung
	 * @var \SoapVar
	 * @internal ST_Waehrungsschluessel
	 */
	protected $Waehrung;
	
	/**
	 * Zahlungsweise
	 * @var \SoapVar
	 * @internal ST_Zahlungsweise
	 */
	protected $Zahlungsweise;
	
	/**
	 * Prozentsatz
	 * @var \SoapVar
	 * @internal ST_Prozent
	 */
	protected $Prozentsatz;
	
	/**
	 * Liefert die Art ID
	 * @return \SoapVar
	 */
	public function getArtID() {
		return $this->ArtID;
	}
	
	/**
	 * Setzt die Art ID
	 * @param \SoapVar $oArtID
	 * @return \MMNewmedia\Janitos\BiPRO\Entity\Tarifierung\Beitrag
	 */
	public function setArtID(\SoapVar $oArtID) {
		$this->ArtID = $oArtID;
		return $this;
	}
	
	/**
	 * Liefert den Betrag
	 * @return \SoapVar
	 */
	public function getBetrag() {
		return $this->Betrag;
	}
	
	/**
	 * Setzt den Betrag
	 * @param \SoapVar $oBetrag
	 * @return \MMNewmedia\Janitos\BiPRO\Entity\Tarifierung\Beitrag
	 */
	public function setBetrag(\SoapVar $oBetrag) {
		$this->Betrag = $oBetrag;
		return $this;
	}
	
	/**
	 * Liefert die Währung
	 * @return \SoapVar
	 */
	public function getWaehrung() {
		return $this->Waehrung;
	}
	
	/**
	 * Setzt die Währung
	 * @param \SoapVar $oWaehrung
	 * @return \MMNewmedia\Janitos\BiPRO\Entity\Tarifierung\Beitrag
	 */
	public function setWaehrung(\SoapVar $oWaehrung) {
		$this->Waehrung = $oWaehrung;
		return $this;
	}
	
	/**
	 * Liefert die Zahlungweise
	 * @return \SoapVar
	 */
	public function getZahlungsweise() {
		return $this->Zahlungsweise;
	}
	
	/**
	 * Setzt die Zahlungsweise
	 * @param \SoapVar $oZahlungsweise
	 * @return \MMNewmedia\Janitos\BiPRO\Entity\Tarifierung\Beitrag
	 */
	public function setZahlungsweise(\SoapVar $oZahlungsweise) {
		$this->Zahlungsweise = $oZahlungsweise;
		return $this;
	}
	
	/**
	 * Liefert den Prozentsatz
	 * @return \SoapVar
	 */
	public function getProzentsatz() {
		return $this->Prozentsatz;
	}
	
	/**
	 * Setzt den Prozentsatz
	 * @param \SoapVar $oProzentsatz
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Beitrag
	 */
	public function setProzentsatz(\SoapVar $oProzentsatz) {
		$this->Prozentsatz = $oProzentsatz;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Beitrag',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}