<?php
namespace MMNewmedia\BiPRO\Entity\Allgemein;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Meldung Entity nach BiPRO Norm (utf-8)
 * Ermoeglicht die Erweiterung einer Statusmeldung um zusaetzliche Informationen (z.B. Fehlermeldungen oder Hinweise), insbesondere
 * dann, wenn eine synchrone Verarbeitung nicht mit einem Ergebnis abgeschlossen werden konnte. In Anhängigkeit zu Status.statusid 
 * MUSS oder KANN das Objekt übermittelt werden.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity
 * @since 2016-03-05
 * @version
 */
class Meldung implements BiPROEntity {
	
	/**
	 * Art der Meldung
	 * @var \SoapVar
	 * @internal ST_Meldungsart
	 */
	protected $ArtID;
	
	/**
	 * Eindeutige Identifizierung der Meldung
	 * @var \SoapVar
	 * @internal ST_Meldung
	 */
	protected $MeldungID;
	
	/**
	 * Meldung als Klartext. Diese MUSS natürlichsprachlich und für einen Endanwender (Vermittler) fachlich verständlich formuliert sein.
	 * Die Meldung DARF auf der Benuteroberfläche angezeigt werden.
	 * @var \SoapVar
	 * @internal ST_Text
	 */
	protected $Text;
	
	/**
	 * Eindeutige Referenz auf das fehlerhafte Objekt und die Objekt-Eigenschaft mittels XPath
	 * @var \SoapVar
	 * @internal ST_Text
	 */
	protected $Quelle;
	
	/**
	 * Alphanumerische eindeutige Kennzeichnung der Meldung bzw. des Fehlers oder Hinweises. Anhand der Nummer wird insbesondere die 
	 * nichttechnische Kommunikation zwischen Nutzer und Anbieter erleichtert.
	 * @var \SoapVar
	 * @internal ST_Text30
	 */
	protected $Identifikationsnummer;
	
	/**
	 * Liefert die ArtID
	 * @return \SoapVar
	 */
	public function getArtID() {
		return $this->ArtID;
	}
	
	/**
	 * Setzt die ArtID
	 * @param \SoapVar $oArtID
	 */
	public function setArtID(\SoapVar $oArtID) {
		$this->ArtID = $oArtID;
	}
	
	/**
	 * Liefert die MeldungID
	 * @return \SoapVar
	 */
	public function getMeldungID() {
		return $this->MeldungID;
	}
	
	/**
	 * Setzt die MeldungID
	 * @param \SoapVar $oMeldungID
	 */
	public function setMeldungID(\SoapVar $oMeldungID) {
		$this->MeldungID = $oMeldungID;
	}
	
	/**
	 * Liefert den Text der Meldung
	 * @return \SoapVar
	 */
	public function getText() {
		return $this->Text;
	}
	
	/**
	 * Setzt den Text der Meldung
	 * @param \SoapVar $oText
	 */
	public function setText(\SoapVar $oText) {
		$this->Text = $oText;
	}
	
	/**
	 * Liefert die Quelle
	 * @return \SoapVar
	 */
	public function getQuelle() {
		return $this->Quelle;
	}
	
	/**
	 * Setzt die Quelle
	 * @param \SoapVar $oQuelle
	 */
	public function setQuelle(\SoapVar $oQuelle) {
		$this->Quelle = $oQuelle;
	}
	
	/**
	 * Liefert die Identifikationsnummer
	 * @return \SoapVar
	 */
	public function getIdentifikationsnummer() {
		return $this->Identifikationsnummer;
	}
	
	/**
	 * Liefert die Identifikationsnummer
	 * @param \SoapVar $oIdentifikationsnummer
	 */
	public function setIdentifikationsnummer(\SoapVar $oIdentifikationsnummer) {
		$this->Identifikationsnummer = $oIdentifikationsnummer;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/allgemein',
			'Meldung',
			'http://www.bipro.net/namespace/allgemein'
		);
		
		return $oEncodedObject;
	}
}