<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

use MMNewmedia\BiPRO\Entity\Allgemein\ProzessAnfrage;

/**
 * QuoteRequest Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewemdia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-17
 * @version
 */
class QuoteRequest extends ProzessAnfrage {
	
	/**
	 * Tarifierung
	 * @var \SoapVar
	 * @internal CT_Tarifierung
	 */
	protected $Tarifierung;
	
	/**
	 * Liefert die Tarifierung
	 * @return \SoapVar
	 */
	public function getTarifierung() {
		return $this->Tarifierung;
	}
	
	/**
	 * Setzt die Tarifierung
	 * @param \SoapVar $oTarifierung
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\QuoteRequest
	 */
	public function setTarifierung(\SoapVar $oTarifierung) {
		$this->Tarifierung = $oTarifierung;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\Allgemein\ProzessAnfrage::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'QuoteRequest',
			'http://www.bipro.net/namespace/tarifierung'
		);
		
		return $oEncodedObject;
	}
}