<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

/**
 * Verkaufpsrodukt Entity nach BiPRO Norm (utf-8)
 * 
 * Oberste Ebene der Produkthierarchie gemaess VAA-Modell. Buendelt Produkte und Verkaufsprodukte zu 
 * einer verkaufbaren Einheit. Darf nicht spartenspezifisch abgeleitet werden, da ansonsten die 
 * spartenuebergreifende Buendelung von Produkten innerhalb des Verkaufsproduktes nicht funktionieren 
 * kann.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-17
 * @version
 */
class Verkaufsprodukt extends Produktbaustein {
	
	/**
	 * Verkaufsprodukt
	 * @var \SoapVar
	 * @internal CT_Verkaufsprodukt
	 */
	protected $Verkaufsprodukt;
	
	/**
	 * Produkt
	 * @var \SoapVar
	 * @internal CT_Produkt
	 */
	protected $Produkt;
	
	/**
	 * Liedert das Verkaufsprodukt
	 * @return \SoapVar
	 */
	public function getVerkaufsprodukt() {
		return $this->Verkaufsprodukt;
	}
	
	/**
	 * Setzt das Verkaufsprodukt
	 * @param \SoapVar $oVerkaufsprodukt
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Verkaufsprodukt
	 */
	public function setVerkaufsprodukt(\SoapVar $oVerkaufsprodukt) {
		$this->Verkaufsprodukt = $oVerkaufsprodukt;
		return $this;
	}
	
	/**
	 * Liefert das Produkt
	 * @return \SoapVar
	 */
	public function getProdukt() {
		return $this->Produkt;
	}
	
	/**
	 * Setzt das Produkt
	 * @param \SoapVar $oProdukt
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Verkaufsprodukt
	 */
	public function setProdukt(\SoapVar $oProdukt) {
		$this->Produkt = $oProdukt;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Verkaufsprodukt',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}