<?php
namespace MMNewmedia\BiPRO\Entity\Allgemein;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Dokumentanforderung Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.allgemein
 * @since 2017-10-17
 * @version
 */
class Dokumentanforderung implements BiPROEntity {
	
	/**
	 * Art des Geschäftsvorgangs
	 * @var \SoapVar
	 * @internal ST_GeVoArtID
	 */
	protected $GeVoArtID;
	
	/**
	 * Versandart
	 * @var \SoapVar
	 * @internal ST_Versandart
	 */
	protected $Versandart;
	
	/**
	 * Empfänger
	 * @var \SoapVar
	 * @internal ST_Partnerrolle
	 */
	protected $Empfaenger;
	
	/**
	 * Referenzempfänger
	 * @var \SoapVar
	 * @internal ST_Text080
	 */
	protected $ReferenzEmpfaenger;
	
	/**
	 * Ist die Vermittleranschrift auf dem Dokument enthalten?
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $VermittleranschriftAufDokument;
	
	/**
	 * Liefert die Art des Geschäftsvorganges
	 * @return \SoapVar
	 */
	public function getGeVoArtID() {
		return $this->GeVoArtID;
	}
	
	/**
	 * Setzt die Art des Geschäftsvorganges
	 * @param \SoapVar $oGeVoArtID
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Dokumentanforderung
	 */
	public function setGeVoArtID(\SoapVar $oGeVoArtID) {
		$this->GeVoArtID = $oGeVoArtID;
		return $this;
	}
	
	/**
	 * Liefert die Versandart
	 * @return \SoapVar
	 */
	public function getVersandart() {
		return $this->Versandart;
	}
	
	/**
	 * Setzt die Versandart
	 * @param \SoapVar $oVersandart
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Dokumentanforderung
	 */
	public function setVersandart(\SoapVar $oVersandart) {
		$this->Versandart = $oVersandart;
		return $this;
	}
	
	/**
	 * Liefert dem Empfänger
	 * @return \SoapVar
	 */
	public function getEmpfaenger() {
		return $this->Empfaenger;
	}
	
	/**
	 * Setzt den Empfänger
	 * @param \SoapVar $oEmpfaenger
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Dokumentanforderung
	 */
	public function setEmpfaenger(\SoapVar $oEmpfaenger) {
		$this->Empfaenger = $oEmpfaenger;
		return $this;
	}
	
	/**
	 * Liefert den Referenz Empfänger
	 * @return \SoapVar
	 */
	public function getReferenzEmpfaenger() {
		return $this->ReferenzEmpfaenger;
	}
	
	/**
	 * Setzt den Referenz Empfänger
	 * @param \SoapVar $oReferenzEmpfaenger
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Dokumentanforderung
	 */
	public function setReferenzEmpfaenger(\SoapVar $oReferenzEmpfaenger) {
		$this->ReferenzEmpfaenger = $oReferenzEmpfaenger;
		return $this;
	}
	
	/**
	 * Liefert, ob die Vermittleranschrift auf dem Dokument erscheinen soll
	 * @return SoapVar
	 */
	public function getVermittleranschriftAufDokument() {
		return $this->VermittleranschriftAufDokument;
	}
	
	/**
	 * Setzt, ob die Vermittleranschrift auf dem Dokument erscheinen soll
	 * @param \SoapVar $oVermittleranschriftAufDokument
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Dokumentanforderung
	 */
	public function setVermittleranschriftAufDokument(\SoapVar $oVermittleranschriftAufDokument) {
		$this->VermittleranschriftAufDokument = $oVermittleranschriftAufDokument;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/allgemein',
			'Dokumentanforderung',
			'http://www.bipro.net/namespace/allgemein'
		);
	
		return $oEncodedObject;
	}
}