<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

/**
 * Kondition Entity nach BiPRO Norm (utf-8)
 * Konditionen beziehen sich auf den Beitrag und nicht auf Leistungen. Z.B. Rabatte.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-18
 * @version
 */
class Kondition extends Produktbaustein {
	
	/**
	 * Eine Kondition MUSS sich auf den Beitrag beziehen. Mit der KategorieID wird festgelegt, ob 
	 * es sich bei der Kondition um einen Zuschlag oder Abschlag handelt.
	 * @var \SoapVar
	 * @internal STE_KategorieID
	 */
	protected $KategorieID;
	
	/**
	 * Wertfreier Name der Kondition. Ob es sich bei der Kondition um einen Zu- oder Abschlag handelt
	 * MUSS über das Attribut KategorieID festgelegt werden.
	 * @var \SoapVar
	 * @internal STE_Kondition
	 */
	protected $ArtID;
	
	/**
	 * Berechnungsgrundlage gemäß Einheit, z.B. Prozentsatz oder Währungsbetrag. Die Ausprägung DARF
	 * NICHT mit Vorzeichen geliefert werden. Ob es sich nun um einen Zu- oder Abschlag handelt, wird
	 * über das Attribut KategorieID gesteuert.
	 * @var \SoapVar
	 * @internal ST_Dezimalzahl
	 */
	protected $Wert;
	
	/**
	 * Einheit der Berechnungsgrundlage (z.B. EUR)
	 * @var \SoapVar
	 * @internal ST_Werteinheit
	 */
	protected $Werteinheit;
	
	/**
	 * Textliche Begründung zur vereinbarten Kondition
	 * @var \SoapVar
	 * @internal ST_Text1000
	 */
	protected $Grund;
	
	/**
	 * Währungsbetrag gemäß Währungsschlüssel
	 * @var \SoapVar
	 * @internal ST_Waehrungsschluessel
	 */
	protected $Waehrung;
	
	/**
	 * Liefert die KategorieID
	 * @return \SoapVar
	 */
	public function getKategorieID() {
		return $this->KategorieID;
	}
	
	/**
	 * Setzt die KategorieID
	 * @param \SoapVar $oKategorieID
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Kondition
	 */
	public function setKategorieID(\SoapVar $oKategorieID) {
		$this->KategorieID = $oKategorieID;
		return $this;
	}
	
	/**
	 * Liefert die Art ID
	 * @return \SoapVar
	 */
	public function getArtID() {
		return $this->ArtID;
	}
	
	/**
	 * Setzt die Art ID
	 * @param \SoapVar $oArtID
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Kondition
	 */
	public function setArtID(\SoapVar $oArtID) {
		$this->ArtID = $oArtID;
		return $this;
	}
	
	/**
	 * Liefert den Wert
	 * @return \SoapVar
	 */
	public function getWert() {
		return $this->Wert;
	}
	
	/**
	 * Setzt den Wert 
	 * @param \SoapVar $oWert
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Kondition
	 */
	public function setWert(\SoapVar $oWert) {
		$this->Wert = $oWert;
		return $this;
	}
	
	/**
	 * Liefert die Werteinheit
	 * @return \SoapVar
	 */
	public function getWerteinheit() {
		return $this->Werteinheit;
	}
	
	/**
	 * Setzt die Werteinheit
	 * @param \SoapVar $oWerteinheit
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Kondition
	 */
	public function setWerteinheit(\SoapVar $oWerteinheit) {
		$this->Werteinheit = $oWerteinheit;
		return $this;
	}
	
	/**
	 * Liefert den Grund
	 * @return SoapVar
	 */
	public function getGrund() {
		return $this->Grund;
	}
	
	/**
	 * Setzt den Grund
	 * @param \SoapVar $oGrund
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Kondition
	 */
	public function setGrund(\SoapVar $oGrund) {
		$this->Grund = $oGrund;
		return $this;
	}
	
	/**
	 * Liefert die Währung
	 * @return SoapVar
	 */
	public function getWaehrung() {
		return $this->Waehrung;
	}
	
	/**
	 * Setzt die Währung
	 * @param \SoapVar $oWaehrung
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Kondition
	 */
	public function setWaehrung(\SoapVar $oWaehrung) {
		$this->Waehrung = $oWaehrung;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Kondition',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}