<?php
namespace MMNewmedia\BiPRO\Entity\Partner;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Ausweis Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.partner
 * @since 2016-10-17
 * @version
 */
class Ausweis implements BiPROEntity {
	
	/**
	 * Ausweistyp
	 * @var \SoapVar
	 * @internal ST_Ausweistyp
	 */
	protected $Ausweistyp;
	
	/**
	 * Ausstellende Behörde
	 * @var \SoapVar
	 * @internal ST_Text080
	 */
	protected $AusstellendeBehoerde;
	
	/**
	 * Ausstellungsdatum
	 * @var \SoapVar
	 * @internal ST_Datum
	 */
	protected $Ausstellungsdatum;
	
	/**
	 * Ausweisnummer
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $Ausweisnummer;
	
	/**
	 * Liefert den Ausweistyp
	 * @return \SoapVar
	 */
	public function getAusweistyp() {
		return $this->Ausweistyp;
	}
	
	/**
	 * Setzt den Ausweistyp
	 * @param \SoapVar $oAusweistyp
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Ausweis
	 */
	public function setAusweistyp(\SoapVar $oAusweistyp) {
		$this->Ausweistyp = $oAusweistyp;
		return $this;
	}
	
	/**
	 * Liefert die ausstellende Behörde
	 * @return \SoapVar
	 */
	public function getAusstellendeBehoerde() {
		return $this->AusstellendeBehoerde;
	}
	
	/**
	 * Setzt die ausstellende Behörde
	 * @param \SoapVar $oAusstellendeBehoerde
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Ausweis
	 */
	public function setAusstellendeBehoerde(\SoapVar $oAusstellendeBehoerde) {
		$this->AusstellendeBehoerde = $oAusstellendeBehoerde;
		return $this;
	}
	
	/**
	 * Liefert das Ausstellungsdatum
	 * @return \SoapVar
	 */
	public function getAusstellungsdatum() {
		return $this->Ausstellungsdatum;
	}
	
	/**
	 * Setzt das Ausstellungsdatum
	 * @param \SoapVar $oAusstellungsdatum
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Ausweis
	 */
	public function setAusstellungsdatum(\SoapVar $oAusstellungsdatum) {
		$this->Ausstellungsdatum = $oAusstellungsdatum;
		return $this;
	}
	
	/**
	 * Liefert die Ausweisnummer
	 * @return \SoapVar
	 */
	public function getAusweisnummer() {
		return $this->Ausweisnummer;
	}
	
	/**
	 * Setzt die Ausweisnummer
	 * @param \SoapVar $oAusweisnummer
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Ausweis
	 */
	public function setAusweisnummer(\SoapVar $oAusweisnummer) {
		$this->Ausweisnummer = $oAusweisnummer;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/partner',
			'Ausweis',
			'http://www.bipro.net/namespace/partner'
		);
	
		return $oEncodedObject;
	}
}