<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

use MMNewmedia\BiPRO\Entity\Allgemein\Geschaeftsvorgang;

/**
 * Tarifierung Entity nach BiPRO Norm (utf-8)
 * Geschaeftsvorgang Tarifierung. Darf nicht spartenspezifisch abgeleitet werden, da sonst die 
 * spartenuebergreifende Buendelung von Produkten nicht mehr moeglich waere.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-17
 * @version
 */
class Tarifierung extends Geschaeftsvorgang {
	
	/**
	 * Verkaufsprodukt
	 * @var \SoapVar
	 * @internal CT_Verkaufsprodukt
	 */
	protected $Verkaufsprodukt;
	
	/**
	 * Liefert das Verkaufsprodukt
	 * @return SoapVar
	 */
	public function getVerkaufsprodukt() {
		return $this->Verkaufsprodukt;
	}
	
	/**
	 * Setzt das Verkaufsprodukt
	 * @param \SoapVar $oVerkaufsprodukt
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Tarifierung
	 */
	public function setVerkaufsprodukt(\SoapVar $oVerkaufsprodukt) {
		$this->Verkaufsprodukt = $oVerkaufsprodukt;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\Allgemein\Geschaeftsvorgang::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Tarifierung',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}