<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

use MMNewmedia\BiPRO\Entity\Allgemein\ProzessAnfrage;

/**
 * Order Request Entity nach BiPRO Norm (utf-8)
 * Nachricht zur Anforderung und zum Einreichen eines Antrags.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-19
 * @version
 */
class OrderRequest extends ProzessAnfrage {
	
	/**
	 * Antrag
	 * @var \SoapVar
	 * @internal CT_Antrag
	 */
	protected $Antrag;
	
	/**
	 * Liefert den Antrag
	 * @return \SoapVar
	 */
	public function getAntrag() {
		return $this->Antrag;
	}
	
	/**
	 * Setzt den Antrag
	 * @param \SoapVar $oAntrag
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\OrderRequest
	 */
	public function setAntrag(\SoapVar $oAntrag) {
		$this->Antrag = $oAntrag;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\Allgemein\ProzessAnfrage::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'OrderRequest',
			'http://www.bipro.net/namespace/tarifierung'
		);
		
		return $oEncodedObject;
	}
}