<?php
namespace MMNewmedia\BiPRO\Entity\Partner;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

class Partner implements BiPROEntity {
	
	/**
	 * Anrede
	 * @var \SoapVar
	 * @internal ST_Anredeschluessel
	 */
	protected $Anrede;
	
	/**
	 * Nachname der Person bzw. des Firmenname des Unternehmens
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $Name;
	
	/**
	 * Namenszusatz
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $Namenszusatz1;
	
	/**
	 * Namenszusatz
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $Namenszusatz2;
	
	/**
	 * Partnernummer VU
	 * Eindeutige Identifizierung des Partners beim Versicherer
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $PartnernummerVU;
	
	/**
	 * Partnernr. beim Vermittler
	 * Eindeutige Identifizierung des Partners beim Vermittler
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $PartnernummerVM;
	
	/**
	 * Vorsteuerabzugsfähigkeit
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $Vorsteuerabzugsberechtigt;
	
	/**
	 * Partnerrolle
	 * @var \SoapVar
	 * @internal CT_Partnerrolle
	 */
	protected $Partnerrolle;
	
	/**
	 * Partneranschrift
	 * Wohnsitz bei natürlichen Personen oder Geschäftssitz bei Firmen
	 * @var \SoapVar
	 * @internal CT_Partneranschrift
	 */
	protected $Partneranschrift;
	
	/**
	 * Bankverbindung
	 * Kontoverbindung des Partners
	 * @var \SoapVar
	 * @internal CT_Bankverbindung
	 */
	protected $Bankverbindung;
	
	/**
	 * Kommunikationsdaten
	 * @var \SoapVar
	 * @internal CT_Kommunikationsverbindung
	 */
	protected $Kommunikationsverbindung;
	
	/**
	 * Liefert den Anredeschlüssel
	 * @return SoapVar
	 */
	public function getAnrede() {
		return $this->Anrede;
	}
	
	/**
	 * Setzt den Anredeschlüssel
	 * @param \SoapVar $oAnrde
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Partner
	 */
	public function setAnrede(\SoapVar $oAnrde) {
		$this->Anrede = $oAnrde;
		return $this;
	}
	
	/**
	 * Liefert den Namen oder die Firmierung
	 * @return SoapVar
	 */
	public function getName() {
		return $this->Name;
	}
	
	/**
	 * Setzt den Namen oder die Firmierung
	 * @param \SoapVar $oName
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Partner
	 */
	public function setName(\SoapVar $oName) {
		$this->Name = $oName;
		return $this;
	}
	
	/**
	 * Liefert den Namenszusatz 1
	 * @return SoapVar
	 */
	public function getNamenszusatz1() {
		return $this->Namenszusatz1;
	}
	
	/**
	 * Setzt den Namenszusatz 1
	 * @param \SoapVar $oNamenszusatz1
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Partner
	 */
	public function setNamenszusatz1(\SoapVar $oNamenszusatz1) {
		$this->Namenszusatz1 = $oNamenszusatz1;
		return $this;
	}
	
	/**
	 * Liefert den Namenszusatz 2
	 * @return SoapVar
	 */
	public function getNamenszusatz2() {
		return $this->Namenszusatz2; 
	}
	
	/**
	 * Setzt den Namenszusatz 2
	 * @param \SoapVar $oNamenszusatz2
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Partner
	 */
	public function setNamenszusatz2(\SoapVar $oNamenszusatz2) {
		$this->Namenszusatz2 = $oNamenszusatz2;
		return $this;
	}
	
	/**
	 * Liefert die Partnernummer VU
	 * @return SoapVar
	 */
	public function getPartnernummerVU() {
		return $this->PartnernummerVU;
	}
	
	/**
	 * Setzt die Partnernummer VU
	 * @param \SoapVar $oPartnernummerVU
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Partner
	 */
	public function setPartnernummerVU(\SoapVar $oPartnernummerVU) {
		$this->PartnernummerVU = $oPartnernummerVU;
		return $this;
	}
	
	/**
	 * Liefert die Partnernummer VM
	 * @return SoapVar
	 */
	public function getPartnernummerVM() {
		return $this->PartnernummerVM;
	}
	
	/**
	 * Setzt die Partnernummer VM
	 * @param \SoapVar $oPartnernummerVM
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Partner
	 */
	public function setPartnernummerVM(\SoapVar $oPartnernummerVM) {
		$this->PartnernummerVM = $oPartnernummerVM;
		return $this;
	}
	
	/**
	 * Liefert das Kennzeichen zur Vorsteuerabzugsberechtigung
	 * @return SoapVar
	 */
	public function getVorsteuerabzugsberechtigt() {
		return $this->Vorsteuerabzugsberechtigt;
	}
	
	/**
	 * Setzt das Kennzeichen zur Vorsteuerabzugsberechtigung
	 * @param \SoapVar $oVorsteuerabzugsberechtigt
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Partner
	 */
	public function setVorsteuerabzugsberechtigt(\SoapVar $oVorsteuerabzugsberechtigt) {
		$this->Vorsteuerabzugsberechtigt = $oVorsteuerabzugsberechtigt;
		return $this;
	}
	
	/**
	 * Liefert die Partnerrolle
	 * @return SoapVar
	 */
	public function getPartnerrolle() {
		return $this->Partnerrolle;
	}
	
	/**
	 * Setzt die Partnerrolle
	 * @param \SoapVar $oPartnerrolle
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Partner
	 */
	public function setPartnerrolle(\SoapVar $oPartnerrolle) {
		$this->Partnerrolle = $oPartnerrolle;
		return $this;
	}
	
	/**
	 * Liefert die Bankverbindung
	 * @return SoapVar
	 */
	public function getBankverbindung() {
		return $this->Bankverbindung;
	}
	
	/**
	 * Setzt die Bankverbindung
	 * @param \SoapVar $oBankverbindung
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Partner
	 */
	public function setBankverbindung(\SoapVar $oBankverbindung) {
		$this->Bankverbindung = $oBankverbindung;
		return $this;
	}
	
	/**
	 * Liefert die Kommunikationsverbindung
	 * @return SoapVar
	 */
	public function getKommunikationsverbindung() {
		return $this->Kommunikationsverbindung;
	}
	
	/**
	 * Setzt die Kommunikationsverbindung
	 * @param \SoapVar $oKommunikationsverbindung
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Partner
	 */
	public function setKommunikationsverbindung(\SoapVar $oKommunikationsverbindung) {
		$this->Kommunikationsverbindung = $oKommunikationsverbindung;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/partner',
			'Partner',
			'http://www.bipro.net/namespace/partner'
		);
	
		return $oEncodedObject;
	}
}