<?php
namespace MMNewmedia\BiPRO\Entity\Allgemein;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Vermittler Entity nach BiPRO Norm (utf-8)
 * Daten des fuer den Geschaeftsvorgang verantwortlichen Vermittlers.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.allgemein
 * @since 2016-10-20
 * @version
 */
class Vermittler implements BiPROEntity {
	
	/**
	 * Vermittlernummer beim VU: Eindeutige Identifizierung des Vermittlers beim Versicherer.
	 * @var \SoapVar
	 * @internal ST_Vermittlernummer
	 */
	protected $VermittlernummerVU;
	
	/**
	 * Vermittlernummer beim Vermittler: Eindeutige Identifizierung des Vermittlers bei Vermittler selbst
	 * @var \SoapVar
	 * @internal ST_Vermittlernummer
	 */
	protected $VermittlernummerVM;
	
	/**
	 * Referenz auf die Partner Daten zum Vermittler
	 * @var \SoapVar
	 * @internal ST_ID
	 */
	protected $PartnerID;
	
	/**
	 * Offizielle Nummer des Vermittlers bei der Industrie- und Handelskammer
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $IHKRegistrierungsnummer;
	
	/**
	 * Art der Vermittlungstätigkeit z.B. im Kontext Beratungsprotokoll bei unterschiedlichen
	 * Anforderungen ja nach Vermittlungstätigkeit
	 * @var \SoapVar
	 * @internal ST_Vermittlerart
	 */
	protected $Art;
	
	/**
	 * Liefert die Vermittlernummer beim Versicherungsunternehmen
	 * @return \SoapVar
	 */
	public function getVermittlernummerVU() {
		return $this->VermittlernummerVU;
	}
	
	/**
	 * Setzt die Vermittlernummer beim Versicherungsunternehmen
	 * @param \SoapVar $oVermittlernummerVU
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Vermittler
	 */
	public function setVermittlernummerVU(\SoapVar $oVermittlernummerVU) {
		$this->VermittlernummerVU = $oVermittlernummerVU;
		return $this;
	}
	
	/**
	 * Liefert die Vermittlernummer beim Vermittler
	 * @return \SoapVar
	 */
	public function getVermittlernummerVM() {
		return $this->VermittlernummerVM;
	}
	
	/**
	 * Setzt die Vermittlernummer beim Vermittler
	 * @param \SoapVar $oVermittlernummerVM
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Vermittler
	 */
	public function setVermittlernummerVM(\SoapVar $oVermittlernummerVM) {
		$this->VermittlernummerVM = $oVermittlernummerVM;
		return $this;
	}
	
	/**
	 * Liefert die Partner ID
	 * @return \SoapVar
	 */
	public function getPartnerID() {
		return $this->PartnerID;
	}
	
	/**
	 * Setzt die Partner ID
	 * @param \SoapVar $oPartnerID
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Vermittler
	 */
	public function setPartnerID(\SoapVar $oPartnerID) {
		$this->PartnerID = $oPartnerID;
		return $this;
	}
	
	/**
	 * Liefert die Registrierungsnummer der IHK
	 * @return \SoapVar
	 */
	public function getIHKRegistrierungsnummer() {
		return $this->IHKRegistrierungsnummer;
	}
	
	/**
	 * Setzt die Registrierungsnummer der IHK
	 * @param \SoapVar $oIHKRegistrierungsnummer
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Vermittler
	 */
	public function setIHKRegistrierungsnummer(\SoapVar $oIHKRegistrierungsnummer) {
		$this->IHKRegistrierungsnummer = $oIHKRegistrierungsnummer;
		return $this;
	}
	
	/**
	 * Liefert die Art
	 * @return \SoapVar
	 */
	public function getArt() {
		return $this->Art;
	}
	
	/**
	 * Setzt die Art
	 * @param \SoapVar $oArt
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Vermittler
	 */
	public function setArt(\SoapVar $oArt) {
		$this->Art = $oArt;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Vermittler',
			'http://www.bipro.net/namespace/allgemein'
		);
	
		return $oEncodedObject;
	}
}