<?php
namespace MMNewmedia\BiPRO\Entity\Allgemein;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Geschäftsvorgang Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.allgemein
 * @since 2016-10-17
 * @version
 */
class Geschaeftsvorgang implements BiPROEntity {
	
	/**
	 * Vorgangsnummer beim Makler
	 * Eindeutige Identifizierung des Geschäftsvorgangs beim Makler
	 * @var \SoapVar
	 * internal ST_Text017
	 */
	protected $VorgangsNummerVU;
	
	/**
	 * Vorgangsnummer beim Versicherer
	 * Eindeutige Identifizierung des Geschäftsvorgangs beim Versicherer
	 * @var \SoapVar
	 * @internal ST_Text017
	 */
	protected $VorgangsNummerVM;
	
	/**
	 * Erstellungsdatum
	 * Datum der Aufgabe des Geschäftsvorgangs
	 * @var \SoapVar
	 * @internal ST_Zeitstempel
	 */
	protected $Erstelldatum;
	
	/**
	 * Freitext
	 * Möglichkeit zur Eingabe eines Hinweises zum Geschäftsvorgang
	 * @var \SoapVar
	 * @internal ST_Text1000
	 */
	protected $Freitext;
	
	/**
	 * Vermittler
	 * @var \SoapVar
	 * @internal CT_Vermittler
	 */
	protected $Vermittler;
	
	/**
	 * Dokumentanforderung
	 * @var \SoapVar
	 * @internal CT_Dokumentanforderung
	 */
	protected $Dokumentanforderung;
	
	/**
	 * Header Datei
	 * @var \SoapVar
	 * @internal CT_Datei
	 */
	protected $HeaderDatei;
	
	public function getVorgangsNummerVU() {
		return $this->VorgangsNummerVU;
	}
	
	public function setVorgangsNummerVU(\SoapVar $oVorgangsNummerVU) {
		$this->VorgangsNummerVU = $oVorgangsNummerVU;
		return $this;
	}
	
	public function getVorgangsNummerVM() {
		return $this->VorgangsNummerVM;
	}
	
	public function setVorgangsNummerVM(\SoapVar $oVorgangsNummerVM) {
		$this->VorgangsNummerVM = $oVorgangsNummerVM;
		return $this;
	}
	
	public function getErstelldatum() {
		return $this->Erstelldatum;
	}
	
	public function setErstelldatum(\SoapVar $oErstelldatum) {
		$this->Erstelldatum = $oErstelldatum;
		return $this;
	}
	
	public function getFreitext() {
		return $this->Freitext;
	}
	
	public function setFreitext(\SoapVar $oFreitext) {
		$this->Freitext = $oFreitext;
		return $this;
	}
	
	public function getVermittler() {
		return $this->Vermittler;
	}
	
	public function setVermittler(\SoapVar $oVermittler) {
		$this->Vermittler = $oVermittler;
		return $this;
	}
	
	public function getDokumentanforderung() {
		return $this->Dokumentanforderung;
	}
	
	public function setDokumentanforderung(\SoapVar $oDokumentanforderung) {
		$this->Dokumentanforderung = $oDokumentanforderung;
		return $this;
	}
	
	public function getHeaderDatei() {
		return $this->HeaderDatei;
	}
	
	public function setHeaderDatei(\SoapVar $oHeaderDatei) {
		$this->HeaderDatei = $oHeaderDatei;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/allgemein',
			'Geschaeftsvorgang',
			'http://www.bipro.net/namespace/allgemein'
		);
	
		return $oEncodedObject;
	}
}