<?php
namespace MMNewmedia\BiPRO\Entity\Partner;

/**
 * Entity einer juristischen Person nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.partner
 * @since 2016-10-17
 * @version
 */
class JuristischePerson extends Partner {
	
	/**
	 * Rechtsform
	 * @var \SoapVar
	 * @internal ST_Rechtsform
	 */
	protected $Rechtsform;
	
	/**
	 * Steuernummer
	 * @var \SoapVar
	 * @internal ST_Steuernummer
	 */
	protected $Steuernummer;
	
	/**
	 * Gründungsdatum
	 * @var \SoapVar
	 * @internal ST_Datum
	 */
	protected $Gruendungsdatum;
	
	/**
	 * Unterschriftenberechtigter
	 * @var \SoapVar
	 * @internal CT_Person
	 */
	protected $Vertretungsberechtigter;
	
	/**
	 * Liefert die Rechtsform
	 * @return \SoapVar
	 */
	public function getRechtsform() {
		return $this->Rechtsform;
	}
	
	/**
	 * Setzt die Rechtsform
	 * @param \SoapVar $oRechtsform
	 * @return \MMNewmedia\BiPRO\Entity\Partner\JuristischePerson
	 */
	public function setRechtsform(\SoapVar $oRechtsform) {
		$this->Rechtsform = $oRechtsform;
		return $this;
	}
	
	/**
	 * Liefert die Steuernummer
	 * @return \SoapVar
	 */
	public function getSteuernummer() {
		return $this->Steuernummer;
	}
	
	/**
	 * Setzt die Steuernummer
	 * @param \SoapVar $oSteuernummer
	 * @return \MMNewmedia\BiPRO\Entity\Partner\JuristischePerson
	 */
	public function setSteuernummer(\SoapVar $oSteuernummer) {
		$this->Steuernummer = $oSteuernummer;
		return $this;
	}
	
	/**
	 * Liefert das Gründungsdatum
	 * @return SoapVar
	 */
	public function getGruendungsdatum() {
		return $this->Gruendungsdatum;
	}
	
	/**
	 * Setzt das Gründungsdatum
	 * @param \SoapVar $oGruendungsdatum
	 * @return \MMNewmedia\BiPRO\Entity\Partner\JuristischePerson
	 */
	public function setGruendungsdatum(\SoapVar $oGruendungsdatum) {
		$this->Gruendungsdatum = $oGruendungsdatum;
		return $this;
	}
	
	/**
	 * Liefert den Vertretungsberechtigten
	 * @return SoapVar
	 */
	public function getVertretungsberechtigter() {
		return $this->Vertretungsberechtigter;
	}
	
	/**
	 * Setzt den Vertretungsberechtigten
	 * @param \SoapVar $oVertretungsberechtigter
	 * @return \MMNewmedia\BiPRO\Entity\Partner\JuristischePerson
	 */
	public function setVertretungsberechtigter(\SoapVar $oVertretungsberechtigter) {
		$this->Vertretungsberechtigter = $oVertretungsberechtigter;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/partner',
			'JuristischePerson',
			'http://www.bipro.net/namespace/partner'
		);
	
		return $oEncodedObject;
	}
}